/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_9296;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class SortCases {
    static Comparator<class_1799> getComparator(SortType sortType) {
        Comparator<class_1799> defaultComparator = Comparator.comparing(SortCases::specialCases);
        switch (sortType.ordinal()) {
            case 1: {
                return Comparator.comparing(SortCases::getGroupIdentifier).thenComparing(defaultComparator);
            }
            case 2: {
                return Comparator.comparing(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836()).thenComparing(defaultComparator);
            }
            case 0: {
                return Comparator.comparing(stack -> {
                    String name = SortCases.specialCases(stack);
                    return String.valueOf(stack.method_7964()) + name;
                });
            }
        }
        return defaultComparator;
    }

    private static int getGroupIdentifier(class_1799 stack) {
        List groups = class_7706.method_47341();
        for (int i = 0; i < groups.size(); ++i) {
            class_1761 group = (class_1761)groups.get(i);
            List stacks = group.method_45414().stream().toList();
            OptionalInt index = IntStream.range(0, stacks.size()).filter(j -> class_1799.method_31577((class_1799)((class_1799)stacks.get(j)), (class_1799)stack)).findFirst();
            if (!index.isPresent()) continue;
            return i * 1000 + index.getAsInt();
        }
        return 99999;
    }

    private static String specialCases(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_9323 component = stack.method_57353();
        if (component != null && component.method_57832(class_9334.field_49617)) {
            return SortCases.playerHeadCase(stack);
        }
        if (stack.method_7947() != stack.method_7914()) {
            return SortCases.stackSize(stack);
        }
        if (stack.method_31574(class_1802.field_8598)) {
            return SortCases.enchantedBookNameCase(stack);
        }
        if (stack.method_7963()) {
            return SortCases.toolDuribilityCase(stack);
        }
        return item.toString();
    }

    private static String playerHeadCase(class_1799 stack) {
        class_9296 profileComponent = (class_9296)stack.method_57353().method_57829(class_9334.field_49617);
        String ownerName = profileComponent.comp_2410().isPresent() ? (String)profileComponent.comp_2410().get() : stack.method_7909().toString();
        String count = "";
        if (stack.method_7947() != stack.method_7914()) {
            count = Integer.toString(stack.method_7947());
        }
        return stack.method_7909().toString() + " " + ownerName + count;
    }

    private static String stackSize(class_1799 stack) {
        return stack.method_7909().toString() + stack.method_7947();
    }

    private static String enchantedBookNameCase(class_1799 stack) {
        class_9304 enchantmentsComponent = (class_9304)stack.method_57353().method_57829(class_9334.field_49643);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (Object2IntMap.Entry entry : enchantmentsComponent.method_57539()) {
            names.add(class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue()).getString());
        }
        Collections.sort(names);
        for (String string : names) {
            enchantNames.append(string).append(" ");
        }
        return stack.method_7909().toString() + " " + enchantmentsComponent.method_57541() + " " + String.valueOf(enchantNames);
    }

    private static String toolDuribilityCase(class_1799 stack) {
        return stack.method_7909().toString() + stack.method_7919();
    }

    public static enum SortType {
        NAME,
        CATEGORY,
        MOD,
        ID;


        public String getTranslationKey() {
            return "key.inventorysorter.sorttype." + this.toString().toLowerCase();
        }
    }
}

