/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.ui.InfoGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_3312;

public class InfoCommand
implements Command {
    private int self(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        User user = Command.getUser(player);
        if (!user.isInFaction()) {
            new Message("Command can only be used whilst in a faction").fail().send((class_1657)player, false);
            return 0;
        }
        return InfoCommand.info(player, user.getFaction());
    }

    private int any(CommandContext<class_2168> context) throws CommandSyntaxException {
        String factionName = StringArgumentType.getString(context, (String)"faction");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        Faction faction = Faction.getByName(factionName);
        if (faction == null) {
            new Message("Faction does not exist").fail().send((class_1657)player, false);
            return 0;
        }
        return InfoCommand.info(player, faction);
    }

    public static int info(class_3222 player, Faction faction) {
        if (FactionsMod.CONFIG.GUI) {
            new InfoGui(player, faction, null);
            return 1;
        }
        List<User> users = faction.getUsers();
        class_3312 cache = player.method_5682().method_3793();
        String owner = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.OWNER).map(user -> cache.method_14512(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        String usersList = users.stream().map(user -> cache.method_14512(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        String mutualAllies = faction.getMutualAllies().stream().map(rel -> Faction.get(rel.target)).map(fac -> String.valueOf(fac.getColor()) + fac.getName()).collect(Collectors.joining(String.valueOf(class_124.field_1080) + ", "));
        String enemiesWith = String.valueOf(class_124.field_1080) + faction.getEnemiesWith().stream().map(rel -> Faction.get(rel.target)).map(fac -> String.valueOf(fac.getColor()) + fac.getName()).collect(Collectors.joining(String.valueOf(class_124.field_1080) + ", "));
        int requiredPower = faction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT;
        int maxPower = users.size() * FactionsMod.CONFIG.POWER.MEMBER + FactionsMod.CONFIG.POWER.BASE;
        int numDashes = 32 - faction.getName().length();
        String dashes = new StringBuilder("--------------------------------").substring(0, numDashes / 2);
        new Message(String.valueOf(class_124.field_1074) + dashes + "[ " + String.valueOf(faction.getColor()) + faction.getName() + String.valueOf(class_124.field_1074) + " ]" + dashes).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Description: ").add(String.valueOf(class_124.field_1068) + faction.getDescription()).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Owner: ").add(String.valueOf(class_124.field_1068) + owner).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Members (" + class_124.field_1068.toString() + users.size() + class_124.field_1065.toString() + "): ").add(usersList).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Power: ").add(class_124.field_1060.toString() + faction.getPower() + InfoCommand.slash() + requiredPower + InfoCommand.slash() + maxPower).hover("Current / Required / Max").send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1060) + "Allies (" + String.valueOf(class_124.field_1068) + faction.getMutualAllies().size() + String.valueOf(class_124.field_1060) + "): ").add(mutualAllies).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1061) + "Enemies (" + String.valueOf(class_124.field_1068) + faction.getEnemiesWith().size() + String.valueOf(class_124.field_1061) + "): ").add(enemiesWith).send((class_1657)player, false);
        return 1;
    }

    private static String slash() {
        return String.valueOf(class_124.field_1080) + " / " + String.valueOf(class_124.field_1060);
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Command.Requires.hasPerms("factions.info", 0))).executes(this::self)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).requires(Command.Requires.hasPerms("factions.info.other", 0))).suggests(Command.Suggests.allFactions()).executes(this::any))).build();
    }
}

