/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.ui.MemberGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_3312;

public class MemberCommand
implements Command {
    private int self(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        User user = Command.getUser(player);
        if (!user.isInFaction()) {
            new Message("Command can only be used whilst in a faction").fail().send((class_1657)player, false);
            return 0;
        }
        return MemberCommand.members(player, user.getFaction());
    }

    private int any(CommandContext<class_2168> context) throws CommandSyntaxException {
        String factionName = StringArgumentType.getString(context, (String)"faction");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        Faction faction = Faction.getByName(factionName);
        if (faction == null) {
            new Message("Faction does not exist").fail().send((class_1657)player, false);
            return 0;
        }
        return MemberCommand.members(player, faction);
    }

    public static int members(class_3222 player, Faction faction) {
        if (FactionsMod.CONFIG.GUI) {
            new MemberGui(player, faction, null);
            return 1;
        }
        List<User> users = faction.getUsers();
        class_3312 cache = player.method_5682().method_3793();
        long memberCount = users.stream().filter(u -> u.rank == User.Rank.MEMBER).count();
        String members = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.MEMBER).map(user -> cache.method_14512(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        long commanderCount = users.stream().filter(u -> u.rank == User.Rank.COMMANDER).count();
        String commanders = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.COMMANDER).map(user -> cache.method_14512(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        long leaderCount = users.stream().filter(u -> u.rank == User.Rank.LEADER).count();
        String leaders = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.LEADER).map(user -> cache.method_14512(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        String owner = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.OWNER).map(user -> cache.method_14512(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).getName()).collect(Collectors.joining(", "));
        int numDashes = 32 - faction.getName().length();
        String dashes = new StringBuilder("--------------------------------").substring(0, numDashes / 2);
        new Message(String.valueOf(class_124.field_1074) + dashes + "[ " + String.valueOf(faction.getColor()) + faction.getName() + String.valueOf(class_124.field_1074) + " ]" + dashes).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Total Members: ").add(class_124.field_1068.toString() + users.size()).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Owner: ").add(owner).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Leaders (" + class_124.field_1068.toString() + leaderCount + class_124.field_1065.toString() + "): ").add(leaders).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Commanders (" + class_124.field_1068.toString() + commanderCount + class_124.field_1065.toString() + "): ").add(commanders).send((class_1657)player, false);
        new Message(String.valueOf(class_124.field_1065) + "Members (" + class_124.field_1068.toString() + memberCount + class_124.field_1065.toString() + "): ").add(members).send((class_1657)player, false);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"members").requires(Command.Requires.hasPerms("factions.members", 0))).executes(this::self)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).requires(Command.Requires.hasPerms("factions.members.other", 0))).suggests(Command.Suggests.allFactions()).executes(this::any))).build();
    }
}

