/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.ui.ModifyGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_3222;

public class ModifyCommand
implements Command {
    private int gui(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Faction faction = Command.getUser(player).getFaction();
        new ModifyGui(player, faction, null);
        return 1;
    }

    private int name(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (FactionsMod.CONFIG.DISPLAY.NAME_BLACKLIST.contains(name.toLowerCase(Locale.ROOT))) {
            new Message("Cannot rename a faction to that name as it is on the blacklist").fail().send((class_1657)player, false);
            return 0;
        }
        if (FactionsMod.CONFIG.DISPLAY.NAME_MAX_LENGTH >= 0 & FactionsMod.CONFIG.DISPLAY.NAME_MAX_LENGTH > name.length()) {
            new Message("Cannot rename a faction to this that as it is too long").fail().send((class_1657)player, false);
            return 0;
        }
        if (Faction.getByName(name) != null) {
            new Message("A faction with that name already exists").fail().send((class_1657)player, false);
            return 0;
        }
        Faction faction = Command.getUser(player).getFaction();
        faction.setName(name);
        new Message("Successfully renamed faction to '" + name + "'").prependFaction(faction).send((class_1657)player, false);
        return 1;
    }

    private int description(CommandContext<class_2168> context) throws CommandSyntaxException {
        String description = StringArgumentType.getString(context, (String)"description");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        Faction faction = Command.getUser(player).getFaction();
        faction.setDescription(description);
        new Message("Successfully updated faction description to '" + description + "'").prependFaction(faction).send((class_1657)player, false);
        return 1;
    }

    private int motd(CommandContext<class_2168> context) throws CommandSyntaxException {
        String motd = StringArgumentType.getString(context, (String)"motd");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        Faction faction = Command.getUser(player).getFaction();
        faction.setMOTD(motd);
        new Message("Successfully updated faction MOTD to '" + motd + "'").prependFaction(faction).send((class_1657)player, false);
        return 1;
    }

    private int color(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_124 color = class_2177.method_9277(context, (String)"color");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        Faction faction = Command.getUser(player).getFaction();
        faction.setColor(color);
        new Message("Successfully updated faction color to " + String.valueOf(class_124.field_1067) + String.valueOf(color) + color.name()).prependFaction(faction).send((class_1657)player, false);
        return 1;
    }

    private int open(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean open = BoolArgumentType.getBool(context, (String)"open");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        Faction faction = Command.getUser(player).getFaction();
        faction.setOpen(open);
        new Message("Successfully updated faction to ").add(new Message(open ? "Open" : "Closed").format(open ? class_124.field_1060 : class_124.field_1061)).prependFaction(faction).send((class_1657)player, false);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").requires(Command.Requires.isLeader())).requires(Command.Requires.multiple(Command.Requires.hasPerms("factions.modify.gui", 0), Command.Requires.isOwner()))).executes(this::gui)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(Command.Requires.multiple(Command.Requires.hasPerms("factions.modify.name", 0), Command.Requires.isOwner()))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::name)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"description").requires(Command.Requires.hasPerms("factions.modify.description", 0))).then(class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(this::description)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"motd").requires(Command.Requires.hasPerms("factions.modify.motd", 0))).then(class_2170.method_9244((String)"motd", (ArgumentType)StringArgumentType.greedyString()).executes(this::motd)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"color").requires(Command.Requires.hasPerms("factions.modify.color", 0))).then(class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).executes(this::color)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open").requires(Command.Requires.hasPerms("factions.modify.open", 0))).then(class_2170.method_9244((String)"open", (ArgumentType)BoolArgumentType.bool()).executes(this::open)))).build();
    }
}

