/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public class PermissionCommand
implements Command {
    private int change(CommandContext<class_2168> context, boolean add) {
        Relationship.Permissions permission;
        String permissionName = StringArgumentType.getString(context, (String)"permission");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        Faction sourceFaction = User.get(player.method_5667()).getFaction();
        Faction targetFaction = Faction.getByName(StringArgumentType.getString(context, (String)"faction"));
        if (sourceFaction == null || targetFaction == null) {
            new Message("You must be in a faction and you must provide a valid function").fail().send((class_1657)player, false);
            return 0;
        }
        Relationship rel = sourceFaction.getRelationship(targetFaction.getID());
        try {
            permission = Relationship.Permissions.valueOf(permissionName);
        }
        catch (IllegalArgumentException e) {
            new Message("Not a valid permission").fail().send((class_1657)player, false);
            return 0;
        }
        if (!rel.permissions.contains((Object)permission) && !add || rel.permissions.contains((Object)permission) && add) {
            new Message(String.format("Could not change because the permission %s", rel.permissions.contains((Object)permission) ? "already exists" : "doesn't exist")).fail().send((class_1657)player, false);
            return 0;
        }
        if (add) {
            rel.permissions.add(permission);
        } else {
            rel.permissions.remove((Object)permission);
        }
        sourceFaction.setRelationship(rel);
        new Message("Successfully changed permissions").send((class_1657)player, false);
        return 1;
    }

    private int add(CommandContext<class_2168> context) {
        return this.change(context, true);
    }

    private int remove(CommandContext<class_2168> context) {
        return this.change(context, false);
    }

    private int changeGuest(CommandContext<class_2168> context, boolean add) {
        Relationship.Permissions permission;
        String permissionName = StringArgumentType.getString(context, (String)"permission");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        Faction faction = User.get(player.method_5667()).getFaction();
        if (faction == null) {
            new Message("You must be in a faction").fail().send((class_1657)player, false);
            return 0;
        }
        try {
            permission = Relationship.Permissions.valueOf(permissionName);
        }
        catch (IllegalArgumentException e) {
            new Message("Not a valid permission").fail().send((class_1657)player, false);
            return 0;
        }
        if (!faction.guest_permissions.contains((Object)permission) && !add || faction.guest_permissions.contains((Object)permission) && add) {
            new Message(String.format("Could not change because the permission %s", faction.guest_permissions.contains((Object)permission) ? "already exists" : "doesn't exist")).fail().send((class_1657)player, false);
            return 0;
        }
        if (add) {
            faction.guest_permissions.add(permission);
        } else {
            faction.guest_permissions.remove((Object)permission);
        }
        new Message("Successfully changed permissions").send((class_1657)player, false);
        return 1;
    }

    private int addGuest(CommandContext<class_2168> context) {
        return this.changeGuest(context, true);
    }

    private int removeGuest(CommandContext<class_2168> context) {
        return this.changeGuest(context, false);
    }

    private int list(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        Faction sourceFaction = User.get(player.method_5667()).getFaction();
        Faction targetFaction = Faction.getByName(StringArgumentType.getString(context, (String)"faction"));
        if (sourceFaction == null || targetFaction == null) {
            new Message("You must be in a faction and you must provide a valid function").fail().send((class_1657)player, false);
            return 0;
        }
        String permissionsList = sourceFaction.getRelationship((UUID)targetFaction.getID()).permissions.stream().map(Enum::toString).collect(Collectors.joining(","));
        new Message("").add(new Message(targetFaction.getName()).format(targetFaction.getColor()).format(class_124.field_1067)).add(String.format(" has the permissions: %s", permissionsList)).send((class_1657)player, false);
        return 1;
    }

    private int listGuest(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        Faction faction = User.get(player.method_5667()).getFaction();
        if (faction == null) {
            new Message("You must be in a faction").fail().send((class_1657)player, false);
            return 0;
        }
        String permissionsList = faction.guest_permissions.stream().map(Enum::toString).collect(Collectors.joining(","));
        new Message(String.format("Guests have the permissions: %s", permissionsList)).send((class_1657)player, false);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permissions").requires(Command.Requires.multiple(Command.Requires.isLeader(), Command.Requires.hasPerms("factions.permission", 0)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Command.Requires.hasPerms("factions.permission.add", 0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"permission", (ArgumentType)StringArgumentType.word()).suggests(Command.Suggests.enumSuggestion(Relationship.Permissions.class)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"faction").requires(Command.Requires.hasPerms("factions.permission.add.faction", 0))).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.allFactions(false)).executes(this::add)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"guest").requires(Command.Requires.hasPerms("factions.permission.add.guest", 0))).executes(this::addGuest))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Command.Requires.hasPerms("factions.permission.remove", 0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"permission", (ArgumentType)StringArgumentType.word()).suggests(Command.Suggests.enumSuggestion(Relationship.Permissions.class)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"faction").requires(Command.Requires.hasPerms("factions.permission.remove.faction", 0))).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.allFactions(false)).executes(this::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"guest").requires(Command.Requires.hasPerms("factions.permission.remove.guest", 0))).executes(this::removeGuest))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Command.Requires.hasPerms("factions.permission.list", 0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"faction").requires(Command.Requires.hasPerms("factions.permission.list.faction", 0))).then(class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).suggests(Command.Suggests.allFactions(false)).executes(this::list)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"guest").requires(Command.Requires.hasPerms("factions.permission.list.guest", 0))).executes(this::listGuest)))).build();
    }
}

