/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.database;

import io.icker.factions.FactionsMod;
import io.icker.factions.database.Field;
import io.icker.factions.database.Name;
import io.icker.factions.database.SerializerRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class Database {
    private static final File BASE_PATH = FabricLoader.getInstance().getGameDir().resolve("factions").toFile();
    private static final HashMap<Class<?>, HashMap<String, java.lang.reflect.Field>> cache = new HashMap();
    private static final String KEY = "CORE";

    public static <T, E> HashMap<E, T> load(Class<T> clazz, Function<T, E> getStoreKey) {
        String name = clazz.getAnnotation(Name.class).value();
        File file = new File(BASE_PATH, name.toLowerCase() + ".dat");
        if (!cache.containsKey(clazz)) {
            Database.setup(clazz);
        }
        HashMap<E, T> store = new HashMap<E, T>();
        if (!file.exists()) {
            if (!BASE_PATH.exists()) {
                BASE_PATH.mkdir();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                FactionsMod.LOGGER.error("Failed to create file ({})", (Object)file, (Object)e);
            }
            return store;
        }
        try {
            class_2499 list = (class_2499)class_2507.method_30613((Path)Path.of(file.getPath(), new String[0]), (class_2505)class_2505.method_53898()).method_10580(KEY);
            for (T item : Database.deserializeList(clazz, list)) {
                store.put(getStoreKey.apply(item), item);
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            FactionsMod.LOGGER.error("Failed to read NBT data ({})", (Object)file, (Object)e);
        }
        return store;
    }

    private static <T> T deserialize(Class<T> clazz, class_2520 value) throws IOException, ReflectiveOperationException {
        if (SerializerRegistry.contains(clazz)) {
            return SerializerRegistry.fromNbtElement(clazz, value);
        }
        class_2487 compound = (class_2487)value;
        T item = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        HashMap<String, java.lang.reflect.Field> fields = cache.get(clazz);
        for (Map.Entry<String, java.lang.reflect.Field> entry : fields.entrySet()) {
            String key = entry.getKey();
            java.lang.reflect.Field field = entry.getValue();
            if (!compound.method_10545(key)) continue;
            Class<?> type = field.getType();
            if (ArrayList.class.isAssignableFrom(type)) {
                Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                field.set(item, Database.deserializeList(genericType, (class_2499)compound.method_10580(key)));
                continue;
            }
            field.set(item, Database.deserialize(type, compound.method_10580(key)));
        }
        return item;
    }

    private static <T> ArrayList<T> deserializeList(Class<T> clazz, class_2499 list) throws IOException, ReflectiveOperationException {
        ArrayList<T> store = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            store.add(Database.deserialize(clazz, list.method_10534(i)));
        }
        return store;
    }

    public static <T> void save(Class<T> clazz, List<T> items) {
        String name = clazz.getAnnotation(Name.class).value();
        File file = new File(BASE_PATH, name.toLowerCase() + ".dat");
        if (!cache.containsKey(clazz)) {
            Database.setup(clazz);
        }
        try {
            class_2487 fileData = new class_2487();
            fileData.method_10566(KEY, (class_2520)Database.serializeList(clazz, items));
            class_2507.method_30614((class_2487)fileData, (Path)Path.of(file.getPath(), new String[0]));
        }
        catch (IOException | ReflectiveOperationException e) {
            FactionsMod.LOGGER.error("Failed to write NBT data ({})", (Object)file, (Object)e);
        }
    }

    private static <T> class_2520 serialize(Class<T> clazz, T item) throws IOException, ReflectiveOperationException {
        if (SerializerRegistry.contains(clazz)) {
            return SerializerRegistry.toNbtElement(clazz, item);
        }
        HashMap<String, java.lang.reflect.Field> fields = cache.get(clazz);
        class_2487 compound = new class_2487();
        for (Map.Entry<String, java.lang.reflect.Field> entry : fields.entrySet()) {
            String key = entry.getKey();
            java.lang.reflect.Field field = entry.getValue();
            Class<?> type = field.getType();
            Object data = field.get(item);
            if (data == null) continue;
            if (ArrayList.class.isAssignableFrom(type)) {
                Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                compound.method_10566(key, (class_2520)Database.serializeList(genericType, (List)Database.cast(data)));
                continue;
            }
            compound.method_10566(key, Database.serialize(type, Database.cast(data)));
        }
        return compound;
    }

    private static <T> class_2499 serializeList(Class<T> clazz, List<T> items) throws IOException, ReflectiveOperationException {
        class_2499 list = new class_2499();
        for (T item : items) {
            list.method_10531(list.size(), Database.serialize(clazz, item));
        }
        return list;
    }

    private static <T> void setup(Class<T> clazz) {
        HashMap<String, java.lang.reflect.Field> fields = new HashMap<String, java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Field.class)) continue;
            field.setAccessible(true);
            fields.put(field.getAnnotation(Field.class).value(), field);
            Class<?> type = field.getType();
            if (SerializerRegistry.contains(type)) continue;
            if (ArrayList.class.isAssignableFrom(type)) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                Database.setup((Class)genericType.getActualTypeArguments()[0]);
                continue;
            }
            Database.setup(type);
        }
        cache.put(clazz, fields);
    }

    private static <T> T cast(Object key) {
        return (T)key;
    }
}

