/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.database;

import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.WorldUtils;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2512;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.apache.commons.lang3.ArrayUtils;

public class SerializerRegistry {
    private static final HashMap<Class<?>, Serializer<?, ? extends class_2520>> registry = new HashMap();

    public static boolean contains(Class<?> clazz) {
        return registry.containsKey(clazz);
    }

    public static <T> class_2520 toNbtElement(Class<T> clazz, T value) {
        return registry.get(clazz).serialize(value);
    }

    public static <T> T fromNbtElement(Class<T> clazz, class_2520 value) {
        return (T)registry.get(clazz).deserialize(value);
    }

    private static <T extends Enum<T>> Serializer<T, class_2519> createEnumSerializer(Class<T> clazz) {
        return new Serializer<Enum, class_2519>(val -> class_2519.method_23256((String)val.toString()), el -> Enum.valueOf(clazz, el.method_10714()));
    }

    private static Serializer<class_1277, class_2499> createInventorySerializer(int size) {
        return new Serializer<class_1277, class_2499>(val -> {
            class_2499 nbtList = new class_2499();
            for (int i = 0; i < val.method_5439(); ++i) {
                class_1799 itemStack = val.method_5438(i);
                if (itemStack.method_7960()) continue;
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_10567("Slot", (byte)i);
                nbtCompound.method_10566("Data", itemStack.method_57358((class_7225.class_7874)WorldUtils.server.method_30611()));
                nbtList.add((Object)nbtCompound);
            }
            return nbtList;
        }, el -> {
            int i;
            class_1277 inventory = new class_1277(size);
            for (i = 0; i < size; ++i) {
                inventory.method_5447(i, class_1799.field_8037);
            }
            for (i = 0; i < el.size(); ++i) {
                class_2487 nbtCompound = el.method_10602(i);
                int slot = nbtCompound.method_10571("Slot") & 0xFF;
                if (slot < 0 || slot >= size) continue;
                inventory.method_5447(slot, (class_1799)class_1799.method_57360((class_7225.class_7874)WorldUtils.server.method_30611(), (class_2520)nbtCompound.method_10580("Data")).get());
            }
            return inventory;
        });
    }

    static {
        registry.put(Byte.TYPE, new Serializer<Byte, class_2481>(val -> class_2481.method_23233((byte)val), el -> el.method_10698()));
        registry.put(Short.TYPE, new Serializer<Short, class_2516>(val -> class_2516.method_23254((short)val), el -> el.method_10696()));
        registry.put(Integer.TYPE, new Serializer<Integer, class_2497>(val -> class_2497.method_23247((int)val), el -> el.method_10701()));
        registry.put(Long.TYPE, new Serializer<Long, class_2503>(val -> class_2503.method_23251((long)val), el -> el.method_10699()));
        registry.put(Float.TYPE, new Serializer<Float, class_2494>(val -> class_2494.method_23244((float)val.floatValue()), el -> Float.valueOf(el.method_10700())));
        registry.put(Double.TYPE, new Serializer<Double, class_2489>(val -> class_2489.method_23241((double)val), el -> el.method_10697()));
        registry.put(Boolean.TYPE, new Serializer<Boolean, class_2481>(val -> class_2481.method_23234((boolean)val), el -> el.method_10698() != 0));
        registry.put(byte[].class, new Serializer<Byte[], class_2479>(val -> new class_2479(ArrayUtils.toPrimitive((Byte[])val)), el -> ArrayUtils.toObject((byte[])el.method_10521())));
        registry.put(int[].class, new Serializer<Integer[], class_2495>(val -> new class_2495(ArrayUtils.toPrimitive((Integer[])val)), el -> ArrayUtils.toObject((int[])el.method_10588())));
        registry.put(long[].class, new Serializer<Long[], class_2501>(val -> new class_2501(ArrayUtils.toPrimitive((Long[])val)), el -> ArrayUtils.toObject((long[])el.method_10615())));
        registry.put(String.class, new Serializer<String, class_2519>(val -> class_2519.method_23256((String)val), el -> el.method_10714()));
        registry.put(UUID.class, new Serializer<UUID, class_2495>(val -> class_2512.method_25929((UUID)val), el -> class_2512.method_25930((class_2520)el)));
        registry.put(class_1277.class, SerializerRegistry.createInventorySerializer(54));
        registry.put(User.ChatMode.class, SerializerRegistry.createEnumSerializer(User.ChatMode.class));
        registry.put(User.SoundMode.class, SerializerRegistry.createEnumSerializer(User.SoundMode.class));
        registry.put(User.Rank.class, SerializerRegistry.createEnumSerializer(User.Rank.class));
        registry.put(Relationship.Status.class, SerializerRegistry.createEnumSerializer(Relationship.Status.class));
        registry.put(Relationship.Permissions.class, SerializerRegistry.createEnumSerializer(Relationship.Permissions.class));
    }

    private static class Serializer<T, E extends class_2520> {
        private final Function<T, E> serializer;
        private final Function<E, T> deserializer;

        public Serializer(Function<T, E> serializer, Function<E, T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public class_2520 serialize(Object value) {
            return (class_2520)this.serializer.apply(value);
        }

        public T deserialize(class_2520 value) {
            return this.deserializer.apply(value);
        }
    }
}

