/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.ui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.api.persistents.User;
import io.icker.factions.command.HomeCommand;
import io.icker.factions.ui.InfoGui;
import io.icker.factions.ui.PagedGui;
import io.icker.factions.util.GuiInteract;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ListGui
extends PagedGui {
    List<Faction> factions;
    int size;
    User user;

    public ListGui(class_3222 player, User user, @Nullable Runnable closeCallback) {
        super(player, closeCallback);
        this.user = user;
        this.factions = new ArrayList<Faction>(Faction.all().stream().toList());
        Faction userFaction = user.getFaction();
        if (userFaction != null) {
            this.factions.remove(userFaction);
            this.factions.addFirst(userFaction);
        }
        this.size = this.factions.size();
        this.setTitle((class_2561)class_2561.method_43470((String)"Factions list"));
        this.updateDisplay();
        this.open();
    }

    @Override
    protected int getPageAmount() {
        return this.size / 36;
    }

    @Override
    protected PagedGui.DisplayElement getElement(int id) {
        if (this.size > id) {
            Faction faction = this.factions.get(id);
            boolean isInFaction = faction.equals(this.user.getFaction());
            Home home = faction.getHome();
            GuiElementBuilder icon = new GuiElementBuilder(class_1802.field_8575);
            icon.setSkullOwner(isInFaction ? "ewogICJ0aW1lc3RhbXAiIDogMTczMzc5NDEzNTI5OSwKICAicHJvZmlsZUlkIiA6ICJlOThhZTBlMTI5MDg0ZDA5OTk0MTg4N2Q2YTk0ZTI2NCIsCiAgInByb2ZpbGVOYW1lIiA6ICJUYXVuYWhpWmVhbG90Qm90IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzMxNjMyZDIwZTQ1YjNlNmE2YWFlZmQzMjgwZmRlMmIzNjdiYmU4NTk3NGUwMzk1YTViZmY1YWNkZWU0MWU2NzYiCiAgICB9CiAgfQp9" : "ewogICJ0aW1lc3RhbXAiIDogMTczMzc5NDEzMzQ5OSwKICAicHJvZmlsZUlkIiA6ICI1ZjU5NmViY2JlOTQ0NmQxYmI0M2JlNGYzZjRiOGJlNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJUZWlsMHNzIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzhkNmQ1ZWM3NzlhM2JkMThlZTllODM3MTJkZDU0MjE5YjQ5NjM3ZjkwZWVlMmJkMThiMjNkYTZkOTlmYjcyMWIiCiAgICB9CiAgfQp9");
            icon.setName((class_2561)class_2561.method_43470((String)(String.valueOf(faction.getColor()) + faction.getName())));
            ArrayList<class_5250> lore = new ArrayList<class_5250>(List.of(class_2561.method_43470((String)faction.getDescription()).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080))));
            if (isInFaction && home != null) {
                lore.add(class_2561.method_43470((String)"Click to view faction info.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)));
                lore.add(class_2561.method_43470((String)"Right-click to teleport to faction home.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1062)));
                icon.setCallback((index, clickType, actionType) -> {
                    GuiInteract.playClickSound(this.player);
                    if (clickType == ClickType.MOUSE_RIGHT) {
                        new HomeCommand().execGo(this.player, faction);
                        this.close();
                        return;
                    }
                    new InfoGui(this.player, faction, () -> ((ListGui)this).open());
                });
            } else {
                lore.add(class_2561.method_43470((String)"Click to view faction info.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)));
                icon.setCallback((index, clickType, actionType) -> {
                    GuiInteract.playClickSound(this.player);
                    new InfoGui(this.player, faction, () -> ((ListGui)this).open());
                });
            }
            icon.setLore(lore);
            return PagedGui.DisplayElement.of(icon);
        }
        return PagedGui.DisplayElement.empty();
    }
}

