/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.ui;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.command.RankCommand;
import io.icker.factions.ui.PagedGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.GuiInteract;
import io.icker.factions.util.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class MemberGui
extends PagedGui {
    Faction faction;
    int size;
    class_3312 cache;
    User user;
    List<User> members;

    public MemberGui(class_3222 player, Faction faction, @Nullable Runnable closeCallback) {
        super(player, closeCallback);
        this.faction = faction;
        this.cache = player.method_5682().method_3793();
        this.user = User.get(player.method_5667());
        this.members = new ArrayList<User>(faction.getUsers());
        if (faction.equals(this.user.getFaction())) {
            this.members.remove(this.user);
            this.members.addFirst(this.user);
        }
        this.size = this.members.size();
        this.setTitle((class_2561)class_2561.method_43470((String)(String.valueOf(faction.getColor()) + faction.getName())).method_10852((class_2561)class_2561.method_43470((String)(" members list (" + this.size + ")"))));
        this.updateDisplay();
        this.open();
    }

    @Override
    protected int getPageAmount() {
        return this.size / 36;
    }

    @Override
    protected PagedGui.DisplayElement getElement(int id) {
        if (this.size > id) {
            User targetUser = this.members.get(id);
            GameProfile unknownPlayer = new GameProfile(UUID.randomUUID(), "{Unknown Player}");
            unknownPlayer.getProperties().put((Object)"textures", (Object)new Property("textures", "ewogICJ0aW1lc3RhbXAiIDogMTczNDIzMjI0OTU3OSwKICAicHJvZmlsZUlkIiA6ICI1ZjU5NmViY2JlOTQ0NmQxYmI0M2JlNGYzZjRiOGJlNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJUZWlsMHNzIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2FlNzgzZmMwNmRlOTRiYTU4YzYyMTc5MGNmMjMxYmZjNThhNGZhMGM1YjIwODdjN2IwOTY1NGI1YWM5YTc5YTIiLAogICAgICAibWV0YWRhdGEiIDogewogICAgICAgICJtb2RlbCIgOiAic2xpbSIKICAgICAgfQogICAgfQogIH0KfQ==", null));
            GameProfile profile = this.cache.method_14512(targetUser.getID()).orElse(unknownPlayer);
            GuiElementBuilder icon = new GuiElementBuilder(class_1802.field_8575);
            icon.setComponent(class_9334.field_49617, (Object)new class_9296(profile));
            icon.setName((class_2561)class_2561.method_43470((String)profile.getName()));
            if (profile.equals((Object)unknownPlayer)) {
                List<class_5250> lore = List.of(class_2561.method_43470((String)"No info available").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)));
                icon.setLore(lore);
                return PagedGui.DisplayElement.of(icon);
            }
            ArrayList<class_5250> lore = new ArrayList<class_5250>(List.of(class_2561.method_43470((String)"Rank: ").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)targetUser.getRankName()).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1060)))));
            if (!profile.getId().equals(this.player.method_5667()) && Command.Requires.isLeader().test(this.player.method_64396()) && Command.Requires.hasPerms("factions.rank.promote", 0).test(this.player.method_64396()) && this.faction.equals(this.user.getFaction())) {
                lore.add(class_2561.method_43470((String)"Click to promote.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1077)));
                lore.add(class_2561.method_43470((String)"Right-click to demote.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1079)));
                lore.add(class_2561.method_43470((String)"Drop (Q) to kick.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1079)));
                class_3222 targetPlayer = this.player.method_5682().method_3760().method_14602(targetUser.getID());
                icon.setCallback((index, clickType, actionType) -> {
                    GuiInteract.playClickSound(this.player);
                    if (clickType == ClickType.MOUSE_LEFT) {
                        try {
                            RankCommand.execPromote(targetUser, this.player);
                            new Message("Promoted " + profile.getName() + " to " + User.get(profile.getId()).getRankName()).prependFaction(this.faction).send((class_1657)this.player, false);
                        }
                        catch (Exception e) {
                            new Message(e.getMessage()).format(class_124.field_1061).send((class_1657)this.player, false);
                            return;
                        }
                    }
                    if (clickType == ClickType.MOUSE_RIGHT) {
                        try {
                            RankCommand.execDemote(targetUser, this.player);
                            new Message("Demoted " + profile.getName() + " to " + User.get(profile.getId()).getRankName()).prependFaction(this.faction).send((class_1657)this.player, false);
                        }
                        catch (Exception e) {
                            new Message(e.getMessage()).format(class_124.field_1061).send((class_1657)this.player, false);
                            return;
                        }
                    }
                    if (clickType == ClickType.DROP) {
                        SimpleGui gui = new SimpleGui(class_3917.field_17337, this.player, false);
                        for (int i = 0; i < 5; ++i) {
                            gui.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8736).hideTooltip());
                        }
                        gui.setTitle((class_2561)class_2561.method_43470((String)"Are you sure?"));
                        gui.setSlot(1, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8777).setName((class_2561)class_2561.method_43470((String)"Click to confirm").method_27692(class_124.field_1060)).setCallback((index2, clickType2, actionType2) -> {
                            if (this.user.rank == User.Rank.LEADER && (targetUser.rank == User.Rank.LEADER || targetUser.rank == User.Rank.OWNER)) {
                                new Message("Cannot kick members with a higher of equivalent rank").format(class_124.field_1061).send((class_1657)this.player, false);
                                return;
                            }
                            GuiInteract.playClickSound(this.player);
                            targetUser.leaveFaction();
                            new Message("Kicked " + this.player.method_5477().getString()).send((class_1657)this.player, false);
                            if (targetPlayer != null) {
                                new Message("You have been kicked from the faction by " + this.player.method_5477().getString()).send((class_1657)targetPlayer, false);
                            }
                            this.open();
                        }));
                        gui.setSlot(3, new GuiElementBuilder(class_1802.field_8615).setName((class_2561)class_2561.method_43470((String)"Click to go back").method_27692(class_124.field_1061)).setCallback(() -> {
                            GuiInteract.playClickSound(this.player);
                            this.open();
                        }));
                        gui.open();
                    }
                    lore.removeFirst();
                    lore.addFirst(class_2561.method_43470((String)"Rank: ").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)targetUser.getRankName()).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1060))));
                    icon.setLore(lore);
                });
            }
            icon.setLore(lore);
            return PagedGui.DisplayElement.of(icon);
        }
        return PagedGui.DisplayElement.empty();
    }
}

