/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.util.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_3218;

public class BlueMapWrapper {
    private HashMap<String, MarkerSet> markerSets = new HashMap();
    private BlueMapAPI api;
    private boolean loadWhenReady = false;

    public BlueMapWrapper() {
        BlueMapAPI.onEnable(api -> {
            this.api = api;
            this.generateMarkers();
        });
        ClaimEvents.ADD.register(this::addClaim);
        ClaimEvents.REMOVE.register(this::removeClaim);
        WorldUtils.ON_READY.register(() -> {
            if (this.loadWhenReady) {
                this.loadWhenReady = false;
                this.generateMarkers();
            }
        });
        FactionEvents.SET_HOME.register(this::setHome);
        FactionEvents.MODIFY.register(faction -> this.updateFaction(faction));
        FactionEvents.MEMBER_JOIN.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.MEMBER_LEAVE.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.POWER_CHANGE.register((faction, oldPower) -> this.updateFaction(faction));
    }

    private void generateMarkers() {
        if (!WorldUtils.isReady()) {
            this.loadWhenReady = true;
            FactionsMod.LOGGER.info("Server hasn't loaded, postponing dynmap marker loading");
            return;
        }
        for (Faction faction : Faction.all()) {
            Home home = faction.getHome();
            if (home != null) {
                this.setHome(faction, home);
            }
            String info = this.getInfo(faction);
            for (Claim claim : faction.getClaims()) {
                this.addClaim(claim, info);
            }
        }
    }

    private void addClaim(Claim claim, String factionInfo) {
        Faction faction = claim.getFaction();
        class_1923 pos = new class_1923(claim.x, claim.z);
        MarkerSet markerSet = this.markerSets.get(claim.level);
        if (markerSet == null) {
            class_3218 world = WorldUtils.getWorld(claim.level);
            markerSet = new MarkerSet("factions-" + claim.level);
            for (BlueMapMap map : ((BlueMapWorld)this.api.getWorld((Object)world).get()).getMaps()) {
                map.getMarkerSets().put("factions-" + claim.level, markerSet);
            }
            this.markerSets.put(claim.level, markerSet);
        }
        ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().position((double)pos.method_33940(), 320.0, (double)pos.method_33942())).shape(Shape.createRect((double)pos.method_8326(), (double)pos.method_8328(), (double)pos.method_8327(), (double)pos.method_8329()), -64.0f, 320.0f).fillColor(new Color(faction.getColor().method_532() | 0x40000000)).lineColor(new Color(faction.getColor().method_532() | 0xFF000000)).label(faction.getName())).detail(factionInfo)).build();
        String areaMarkerId = String.format("%s-%d-%d", claim.level, claim.x, claim.z);
        markerSet.put(areaMarkerId, (Marker)marker);
    }

    private void addClaim(Claim claim) {
        this.addClaim(claim, this.getInfo(claim.getFaction()));
    }

    private void removeClaim(int x, int z, String level, Faction faction) {
        MarkerSet markerSet = this.markerSets.get(level);
        if (markerSet != null) {
            String areaMarkerId = String.format("%s-%d-%d", level, x, z);
            markerSet.remove(areaMarkerId);
        }
    }

    private void updateFaction(Faction faction) {
        String info = this.getInfo(faction);
        for (Claim claim : faction.getClaims()) {
            MarkerSet markerSet = this.markerSets.get(claim.level);
            if (markerSet == null) continue;
            String areaMarkerId = String.format("%s-%d-%d", claim.level, claim.x, claim.z);
            ExtrudeMarker marker = (ExtrudeMarker)markerSet.get(areaMarkerId);
            marker.setFillColor(new Color(faction.getColor().method_532() | 0x40000000));
            marker.setLineColor(new Color(faction.getColor().method_532() | 0xFF000000));
            marker.setLabel(faction.getName());
            marker.setDetail(info);
        }
    }

    private void setHome(Faction faction, Home home) {
        if (home == null) {
            for (Map.Entry<String, MarkerSet> entry : this.markerSets.entrySet()) {
                entry.getValue().remove(faction.getID().toString() + "-home");
            }
            return;
        }
        MarkerSet markerSet = this.markerSets.get(home.level);
        if (markerSet == null) {
            class_3218 world = WorldUtils.getWorld(home.level);
            markerSet = new MarkerSet("factions-" + home.level);
            for (BlueMapMap map : ((BlueMapWorld)this.api.getWorld((Object)world).get()).getMaps()) {
                map.getMarkerSets().put("factions-" + home.level, markerSet);
            }
            this.markerSets.put(home.level, markerSet);
        }
        for (Map.Entry entry : this.markerSets.entrySet()) {
            if (((String)entry.getKey()).equals(home.level)) continue;
            ((MarkerSet)entry.getValue()).remove(faction.getID().toString() + "-home");
        }
        Marker marker = markerSet.get(faction.getID().toString() + "-home");
        if (marker == null) {
            POIMarker pOIMarker = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().position(home.x, home.y, home.z)).detail(this.getInfo(faction)).label(faction.getName() + "'s Home")).build();
            markerSet.put(faction.getID().toString() + "-home", (Marker)pOIMarker);
        } else {
            ((POIMarker)marker).setPosition(home.x, home.y, home.z);
        }
    }

    private String getInfo(Faction faction) {
        return "Name: " + faction.getName() + "<br>Description: " + faction.getDescription() + "<br>Power: " + faction.getPower() + "<br>Number of members: " + faction.getUsers().size();
    }
}

