/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.util.WorldUtils;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class DynmapWrapper {
    private DynmapCommonAPI api;
    private MarkerAPI markerApi;
    private MarkerSet markerSet;
    private boolean loadWhenReady = false;

    public DynmapWrapper() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI dCAPI) {
                DynmapWrapper.this.api = dCAPI;
                DynmapWrapper.this.markerApi = DynmapWrapper.this.api.getMarkerAPI();
                DynmapWrapper.this.markerSet = DynmapWrapper.this.markerApi.getMarkerSet("dynmap-factions");
                if (DynmapWrapper.this.markerSet == null) {
                    DynmapWrapper.this.markerSet = DynmapWrapper.this.markerApi.createMarkerSet("dynmap-factions", "The Dynmap Factions integration", null, true);
                }
                DynmapWrapper.this.markerSet.getMarkers().forEach(GenericMarker::deleteMarker);
                DynmapWrapper.this.generateMarkers();
            }
        });
        ClaimEvents.ADD.register(this::addClaim);
        ClaimEvents.REMOVE.register(this::removeClaim);
        WorldUtils.ON_READY.register(() -> {
            if (this.loadWhenReady) {
                this.loadWhenReady = false;
                this.generateMarkers();
            }
        });
        FactionEvents.SET_HOME.register(this::setHome);
        FactionEvents.MODIFY.register(faction -> this.updateFaction(faction));
        FactionEvents.MEMBER_JOIN.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.MEMBER_LEAVE.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.POWER_CHANGE.register((faction, oldPower) -> this.updateFaction(faction));
    }

    private void generateMarkers() {
        if (!WorldUtils.isReady()) {
            this.loadWhenReady = true;
            FactionsMod.LOGGER.info("Server hasn't loaded, postponing dynmap marker loading");
            return;
        }
        for (Faction faction : Faction.all()) {
            Home home = faction.getHome();
            if (home != null) {
                this.setHome(faction, home);
            }
            String info = this.getInfo(faction);
            for (Claim claim : faction.getClaims()) {
                this.addClaim(claim, info);
            }
        }
    }

    private void addClaim(Claim claim, String factionInfo) {
        Faction faction = claim.getFaction();
        class_1923 pos = new class_1923(claim.x, claim.z);
        AreaMarker marker = this.markerSet.createAreaMarker(claim.getKey(), factionInfo, true, this.dimensionTagToID(claim.level), new double[]{pos.method_8326(), pos.method_8327() + 1}, new double[]{pos.method_8328(), pos.method_8329() + 1}, true);
        if (marker != null) {
            marker.setFillStyle(marker.getFillOpacity(), faction.getColor().method_532().intValue());
            marker.setLineStyle(marker.getLineWeight(), marker.getLineOpacity(), faction.getColor().method_532().intValue());
        }
    }

    private void addClaim(Claim claim) {
        this.addClaim(claim, this.getInfo(claim.getFaction()));
    }

    private void removeClaim(int x, int z, String level, Faction faction) {
        String areaMarkerId = String.format("%s-%d-%d", level, x, z);
        this.markerSet.findAreaMarker(areaMarkerId).deleteMarker();
    }

    private void updateFaction(Faction faction) {
        String info = this.getInfo(faction);
        for (Claim claim : faction.getClaims()) {
            AreaMarker marker = this.markerSet.findAreaMarker(claim.getKey());
            marker.setFillStyle(marker.getFillOpacity(), faction.getColor().method_532().intValue());
            marker.setLineStyle(marker.getLineWeight(), marker.getLineOpacity(), faction.getColor().method_532().intValue());
            marker.setDescription(info);
        }
    }

    private void setHome(Faction faction, Home home) {
        Marker marker = this.markerSet.findMarker(faction.getID().toString() + "-home");
        if (home == null && marker != null) {
            marker.deleteMarker();
            return;
        }
        if (marker == null) {
            this.markerSet.createMarker(faction.getID().toString() + "-home", faction.getName() + "'s Home", this.dimensionTagToID(home.level), home.x, home.y, home.z, null, true);
        } else {
            marker.setLocation(this.dimensionTagToID(home.level), home.x, home.y, home.z);
        }
    }

    public String getWorldName(class_1937 w) {
        class_5321 rk = w.method_27983();
        if (rk == class_1937.field_25179) {
            return w.method_8503().method_27728().method_150();
        }
        if (rk == class_1937.field_25181) {
            return "DIM1";
        }
        if (rk == class_1937.field_25180) {
            return "DIM-1";
        }
        return rk.method_29177().method_12836() + "_" + rk.method_29177().method_12832();
    }

    public String dimensionTagToID(String dimension_id) {
        if (!WorldUtils.isReady()) {
            FactionsMod.LOGGER.warn("Server object has not been initialized please run the dynmap reload command");
            return dimension_id;
        }
        class_3218 world = WorldUtils.getWorld(dimension_id);
        if (world == null) {
            FactionsMod.LOGGER.error(String.format("Unable to find dimension id: %s", dimension_id));
            return dimension_id;
        }
        return this.getWorldName((class_1937)world);
    }

    private String getInfo(Faction faction) {
        return "Name: " + faction.getName() + "<br>Description: " + faction.getDescription() + "<br>Power: " + faction.getPower() + "<br>Number of members: " + faction.getUsers().size();
    }

    public void reloadAll() {
        this.markerSet.deleteMarkerSet();
        this.markerSet = this.markerApi.createMarkerSet("dynmap-factions", "The Dynmap Factions integration", null, true);
        this.generateMarkers();
    }
}

