/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1923;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquareMapWrapper {
    private HashMap<String, SimpleLayerProvider> layers = new HashMap();
    private Squaremap api;

    public SquareMapWrapper() {
        ClaimEvents.ADD.register(this::addClaim);
        ClaimEvents.REMOVE.register(this::removeClaim);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.api = SquaremapProvider.get();
            this.generateMarkers();
        });
        FactionEvents.SET_HOME.register(this::setHome);
        FactionEvents.MODIFY.register(faction -> this.updateFaction(faction));
        FactionEvents.MEMBER_JOIN.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.MEMBER_LEAVE.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.POWER_CHANGE.register((faction, oldPower) -> this.updateFaction(faction));
    }

    private void generateMarkers() {
        for (Faction faction : Faction.all()) {
            Home home = faction.getHome();
            if (home != null) {
                this.setHome(faction, home);
            }
            String info = this.getInfo(faction);
            for (Claim claim : faction.getClaims()) {
                this.addClaim(claim, info);
            }
        }
    }

    private void addClaim(Claim claim, String factionInfo) {
        Faction faction = claim.getFaction();
        class_1923 pos = new class_1923(claim.x, claim.z);
        SimpleLayerProvider layer = this.layers.get(claim.level);
        if (layer == null) {
            layer = SimpleLayerProvider.builder((String)("factions-" + claim.level)).showControls(true).build();
            MapWorld world = this.api.getWorldIfEnabled(WorldIdentifier.parse((String)claim.level)).orElse(null);
            if (world != null) {
                world.layerRegistry().register(Key.of((String)("factions-" + claim.level.replace(':', '-'))), (Object)layer);
            }
            this.layers.put(claim.level, layer);
        }
        Marker marker = Marker.rectangle((Point)Point.of((double)pos.method_8326(), (double)pos.method_8328()), (Point)Point.of((double)pos.method_8327(), (double)pos.method_8329())).markerOptions(MarkerOptions.builder().fillColor(new Color(faction.getColor().method_532())).strokeColor(new Color(faction.getColor().method_532())).hoverTooltip(faction.getName()).clickTooltip(factionInfo));
        String areaMarkerId = String.format("%s-%d-%d", claim.level.replace(':', '-'), claim.x, claim.z);
        layer.addMarker(Key.of((String)areaMarkerId), marker);
    }

    private void addClaim(Claim claim) {
        this.addClaim(claim, this.getInfo(claim.getFaction()));
    }

    private void removeClaim(int x, int z, String level, Faction faction) {
        SimpleLayerProvider layer = this.layers.get(level);
        if (layer != null) {
            String areaMarkerId = String.format("%s-%d-%d", level.replace(':', '-'), x, z);
            layer.removeMarker(Key.of((String)areaMarkerId));
        }
    }

    private void updateFaction(Faction faction) {
        String info = this.getInfo(faction);
        for (Claim claim : faction.getClaims()) {
            SimpleLayerProvider layer = this.layers.get(claim.level);
            if (layer == null) continue;
            String areaMarkerId = String.format("%s-%d-%d", claim.level.replace(':', '-'), claim.x, claim.z);
            Marker marker = (Marker)layer.registeredMarkers().get(Key.of((String)areaMarkerId));
            marker.markerOptions(MarkerOptions.builder().fillColor(new Color(faction.getColor().method_532())).strokeColor(new Color(faction.getColor().method_532())).hoverTooltip(faction.getName()).clickTooltip(info));
        }
    }

    private void setHome(Faction faction, Home home) {
        if (home == null) {
            for (Map.Entry<String, SimpleLayerProvider> entry : this.layers.entrySet()) {
                entry.getValue().removeMarker(Key.of((String)(faction.getID().toString() + "-home")));
            }
            return;
        }
        SimpleLayerProvider layer = this.layers.get(home.level);
        if (layer == null) {
            layer = SimpleLayerProvider.builder((String)("factions-" + home.level)).showControls(true).build();
            MapWorld world = this.api.getWorldIfEnabled(WorldIdentifier.parse((String)home.level)).orElse(null);
            if (world != null) {
                world.layerRegistry().register(Key.of((String)("factions-" + home.level.replace(':', '-'))), (Object)layer);
            }
            this.layers.put(home.level, layer);
        }
        for (Map.Entry<String, SimpleLayerProvider> entry : this.layers.entrySet()) {
            if (entry.getKey().equals(home.level)) continue;
            entry.getValue().removeMarker(Key.of((String)(faction.getID().toString() + "-home")));
        }
        Marker marker = (Marker)layer.registeredMarkers().get(Key.of((String)(faction.getID().toString() + "-home")));
        if (marker == null) {
            Marker homeMarker = Marker.icon((Point)Point.of((double)home.x, (double)home.z), (Key)Key.of((String)"squaremap-spawn_icon"), (int)16).markerOptions(MarkerOptions.builder().clickTooltip(this.getInfo(faction)).hoverTooltip(faction.getName() + "'s Home"));
            layer.addMarker(Key.of((String)(faction.getID().toString() + "-home")), homeMarker);
        } else {
            ((Icon)marker).point(Point.of((double)home.x, (double)home.z));
        }
    }

    private String getInfo(Faction faction) {
        return "Name: " + faction.getName() + "<br>Description: " + faction.getDescription() + "<br>Power: " + faction.getPower() + "<br>Number of members: " + faction.getUsers().size();
    }
}

