/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_10537;
import net.minecraft.class_10539;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import software.bernie.geckolib.GeckoLibServices;

public abstract class GeoAbstractTexture
extends class_10537 {
    public GeoAbstractTexture(class_2960 resourceId) {
        super(resourceId);
    }

    protected static void generateTexture(class_2960 texturePath, Consumer<class_1060> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (!(textureManager.method_4619(texturePath) instanceof GeoAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public class_10539 method_65809(class_3300 resourceManager) throws IOException {
        return this.loadTexture(resourceManager, class_310.method_1551());
    }

    protected void printDebugImageToDisk(class_2960 id, class_1011 newImage) {
        try {
            File file = new File(GeckoLibServices.PLATFORM.getGameDir().toFile(), "GeoTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, id.method_12832().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            newImage.method_4325(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract class_10539 loadTexture(class_3300 var1, class_310 var2) throws IOException;

    public static void uploadTexture(class_1044 texture, class_10539 textureContents) {
        GeoAbstractTexture.uploadTexture(texture, textureContents.comp_3447(), textureContents.method_65873(), textureContents.method_65872(), 0, 0, textureContents.comp_3447().method_4307(), textureContents.comp_3447().method_4323(), true);
    }

    public static void uploadTexture(class_1044 texture, class_1011 image, boolean clamp, boolean blur, int skipXPixels, int skipYPixels, int width, int height, boolean autoClose) {
        texture.field_5205 = blur;
        class_4573 uploadTask = () -> {
            TextureUtil.prepareImage((int)texture.method_4624(), (int)0, (int)width, (int)height);
            texture.method_4527(blur, false);
            texture.method_65924(clamp);
            image.method_22619(0, 0, 0, skipXPixels, skipYPixels, width, height, autoClose);
        };
        GeoAbstractTexture.runOnRenderThread(uploadTask);
    }

    public static void runOnRenderThread(class_4573 renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((class_4573)renderCall);
        } else {
            renderCall.execute();
        }
    }

    public static class_2960 appendToPath(class_2960 location, String suffix) {
        String path = location.method_12832();
        int i = path.lastIndexOf(46);
        return class_2960.method_60655((String)location.method_12836(), (String)(path.substring(0, i) + suffix + path.substring(i)));
    }
}

