/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import java.util.function.Function;
import net.minecraft.class_10017;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10394;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2484;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_836;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.object.Color;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderUtil;

public class ItemArmorGeoLayer<T extends class_1309>
extends GeoRenderLayer<T> {
    protected final class_10197 equipmentRenderer;
    protected final Function<class_2484.class_2485, class_5598> skullModels;
    @Nullable
    protected class_1799 mainHandStack;
    @Nullable
    protected class_1799 offhandStack;
    @Nullable
    protected class_1799 helmetStack;
    @Nullable
    protected class_1799 chestplateStack;
    @Nullable
    protected class_1799 leggingsStack;
    @Nullable
    protected class_1799 bootsStack;

    public ItemArmorGeoLayer(GeoRenderer<T> geoRenderer, class_10197 equipmentLayerRenderer) {
        super(geoRenderer);
        this.equipmentRenderer = equipmentLayerRenderer;
        this.skullModels = class_156.method_34866(type -> class_836.method_32160((class_5599)class_310.method_1551().method_31974(), (class_2484.class_2485)type));
    }

    @NotNull
    protected class_1304 getEquipmentSlotForBone(GeoBone bone, class_1799 stack, T animatable) {
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178 || stack != animatable.method_6118(slot)) continue;
            return slot;
        }
        return class_1304.field_6174;
    }

    @NotNull
    protected class_630 getModelPartForBone(GeoBone bone, class_1304 slot, class_1799 stack, T animatable, class_572<?> baseModel) {
        return baseModel.field_3391;
    }

    @Nullable
    protected class_1799 getArmorItemForBone(GeoBone bone, T animatable) {
        return null;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        this.mainHandStack = animatable.method_6118(class_1304.field_6173);
        this.offhandStack = animatable.method_6118(class_1304.field_6171);
        this.helmetStack = animatable.method_6118(class_1304.field_6169);
        this.chestplateStack = animatable.method_6118(class_1304.field_6174);
        this.leggingsStack = animatable.method_6118(class_1304.field_6172);
        this.bootsStack = animatable.method_6118(class_1304.field_6166);
    }

    @Override
    public void renderForBone(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        class_1747 blockItem;
        class_1799 armorStack = this.getArmorItemForBone(bone, animatable);
        if (armorStack == null || armorStack.method_7960()) {
            return;
        }
        class_1792 class_17922 = armorStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2190) {
            class_2190 skullBlock = (class_2190)class_17922;
            this.renderSkullAsArmor(poseStack, bone, armorStack, skullBlock, bufferSource, packedLight);
        } else {
            class_1304 slot = this.getEquipmentSlotForBone(bone, armorStack, animatable);
            class_572<?> model = this.getModelForItem(bone, slot, armorStack, animatable);
            class_630 modelPart = this.getModelPartForBone(bone, slot, armorStack, animatable, model);
            if (!modelPart.field_3663.isEmpty()) {
                poseStack.method_22903();
                poseStack.method_22905(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)model;
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    geoArmorRenderer.prepForRender((class_1297)animatable, armorStack, slot, model, bufferSource, partialTick, 0.0f, 0.0f);
                    geoArmorRenderer.applyBoneVisibilityByPart(slot, modelPart, model);
                    geoArmorRenderer.method_62100(poseStack, null, packedLight, packedOverlay, Color.WHITE.argbInt());
                } else {
                    class_10192 equippable = (class_10192)armorStack.method_57824(class_9334.field_54196);
                    if (equippable != null) {
                        equippable.comp_3176().ifPresent(modelPath -> {
                            this.prepModelPartForRender(poseStack, bone, modelPart);
                            this.renderVanillaArmorPiece(poseStack, animatable, bone, slot, armorStack, equippable, (class_5321<class_10394>)modelPath, model, modelPart, bufferSource, partialTick, packedLight, packedOverlay);
                        });
                    }
                }
                poseStack.method_22909();
            }
        }
    }

    protected void renderVanillaArmorPiece(class_4587 poseStack, T animatable, GeoBone bone, class_1304 slot, class_1799 armorStack, class_10192 equippable, class_5321<class_10394> equipmentAsset, class_572<?> model, class_630 modelPart, class_4597 bufferSource, float partialTick, int packedLight, int packedOverlay) {
        class_10186.class_10190 layerType = slot == class_1304.field_6172 ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125;
        this.setVanillaModelPartVisibility(animatable, armorStack, bone, model, modelPart, slot, partialTick);
        this.equipmentRenderer.method_64077(layerType, equipmentAsset, model, armorStack, poseStack, bufferSource, packedLight);
    }

    @Deprecated(forRemoval=true)
    protected void setVanillaModelPartVisibility(class_572<?> baseModel, class_1304 slot) {
    }

    protected void setVanillaModelPartVisibility(T animatable, class_1799 armorStack, GeoBone bone, class_572<?> baseModel, class_630 modelPart, class_1304 slot, float partialTick) {
        baseModel.method_2805(false);
        modelPart.field_3665 = true;
    }

    @NotNull
    protected class_572<?> getModelForItem(GeoBone bone, class_1304 slot, class_1799 stack, T animatable) {
        class_572 humanoidModel;
        class_10034 renderState;
        GeoEntityRenderer entityRenderer;
        class_572 defaultModel = slot == class_1304.field_6172 ? GeckoLibClient.GENERIC_INNER_ARMOR_MODEL.get() : GeckoLibClient.GENERIC_OUTER_ARMOR_MODEL.get();
        class_10017 class_100172 = this.getRenderer();
        class_3879 model = GeckoLibServices.Client.ITEM_RENDERING.getArmorModelForItem(animatable, class_100172 instanceof GeoEntityRenderer && (class_100172 = (entityRenderer = (GeoEntityRenderer)class_100172).getEntityRenderState()) instanceof class_10034 ? (renderState = (class_10034)class_100172) : new class_10034(), stack, slot, slot == class_1304.field_6172 ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125, defaultModel);
        return model instanceof class_572 ? (humanoidModel = (class_572)model) : defaultModel;
    }

    protected void renderSkullAsArmor(class_4587 poseStack, GeoBone bone, class_1799 stack, class_2190 skullBlock, class_4597 bufferSource, int packedLight) {
        class_2484.class_2485 type = skullBlock.method_9327();
        class_5598 model = this.skullModels.apply(type);
        class_1921 renderType = class_836.method_65832((class_2484.class_2485)type, (class_9296)((class_9296)stack.method_57824(class_9334.field_49617)));
        poseStack.method_22903();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.method_22905(1.1875f, 1.1875f, 1.1875f);
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)poseStack, (class_4597)bufferSource, (int)packedLight, (class_5598)model, (class_1921)renderType);
        poseStack.method_22909();
    }

    protected void prepModelPartForRender(class_4587 poseStack, GeoBone bone, class_630 sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        class_630.class_628 armorCube = (class_630.class_628)sourcePart.field_3663.getFirst();
        double armorBoneSizeX = firstCube.size().method_10216();
        double armorBoneSizeY = firstCube.size().method_10214();
        double armorBoneSizeZ = firstCube.size().method_10215();
        double actualArmorSizeX = Math.abs(armorCube.field_3648 - armorCube.field_3645);
        double actualArmorSizeY = Math.abs(armorCube.field_3647 - armorCube.field_3644);
        double actualArmorSizeZ = Math.abs(armorCube.field_3646 - armorCube.field_3643);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.method_2851(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.field_3654 = -bone.getRotX();
        sourcePart.field_3675 = -bone.getRotY();
        sourcePart.field_3674 = bone.getRotZ();
        poseStack.method_22905(scaleX, scaleY, scaleZ);
    }
}

