/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.main;

import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.log.ChatLog;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.render.map.MapRenderer;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;

public class DeleteMapTask
implements IMainThreadTask {
    private static String NAME = "Tick." + MappingMonitorTask.class.getSimpleName();
    private static Logger LOGGER = Journeymap.getLogger();
    boolean allDims;
    RegionCoord regionCoord;
    MapType mapType;

    private DeleteMapTask(boolean allDims) {
        this.allDims = allDims;
    }

    public DeleteMapTask(RegionCoord regionCoord, MapType mapType) {
        this.regionCoord = regionCoord;
        this.mapType = mapType;
    }

    public static void queue(boolean allDims) {
        JourneymapClient.getInstance().queueMainThreadTask(new DeleteMapTask(allDims));
    }

    public static void queue(RegionCoord regionCoord, MapType mapType) {
        JourneymapClient.getInstance().queueMainThreadTask(new DeleteMapTask(regionCoord, mapType));
    }

    @Override
    public final IMainThreadTask perform(class_310 mc, JourneymapClient jm) {
        if (this.regionCoord != null) {
            this.deleteRegion(jm);
        } else {
            this.deleteMap(jm);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRegion(JourneymapClient jm) {
        try {
            jm.toggleTask(MapPlayerTask.Manager.class, false, false);
            jm.toggleTask(MapRegionTask.Manager.class, false, false);
            MapRenderer.setEnabled(false);
            for (class_1923 chunkPos : this.regionCoord.getChunkCoordsInRegion()) {
                DataCache.INSTANCE.invalidateChunkMD(chunkPos);
            }
            RegionDataStorageHandler.getInstance().removeRegion(this.regionCoord, Fullscreen.state().getMapType());
            boolean ok = RegionImageCache.INSTANCE.deleteRegion(this.regionCoord, Fullscreen.state());
            if (ok) {
                ChatLog.announceI18N("jm.common.delete_region_status_done", new Object[0]);
            } else {
                ChatLog.announceI18N("jm.common.delete_region_status_error", new Object[0]);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error deleting region: ", t);
        }
        finally {
            MapRenderer.setEnabled(true);
            jm.toggleTask(MapPlayerTask.Manager.class, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMap(JourneymapClient jm) {
        try {
            jm.toggleTask(MapPlayerTask.Manager.class, false, false);
            jm.toggleTask(MapRegionTask.Manager.class, false, false);
            MapRenderer.setEnabled(false);
            boolean wasMapping = JourneymapClient.getInstance().isMapping();
            if (wasMapping) {
                JourneymapClient.getInstance().stopMapping();
            }
            DataCache.INSTANCE.invalidateChunkMDCache();
            RegionDataStorageHandler.getInstance().deleteCache();
            boolean ok = RegionImageCache.INSTANCE.deleteMap(Fullscreen.state(), this.allDims);
            if (ok) {
                ChatLog.announceI18N("jm.common.deletemap_status_done", new Object[0]);
            } else {
                ChatLog.announceI18N("jm.common.deletemap_status_error", new Object[0]);
            }
            if (wasMapping) {
                JourneymapClient.getInstance().startMapping();
                MapPlayerTask.forceNearbyRemap();
            }
            Fullscreen.state().requireRefresh();
        }
        finally {
            MapRenderer.setEnabled(true);
            jm.toggleTask(MapPlayerTask.Manager.class, true, true);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

