/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.keymapping.UpdateAwareKeyBinding;
import journeymap.client.io.ThemeLoader;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.theme.Theme;
import net.minecraft.class_2338;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4597;

public class KeybindingInfoLayer
extends Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    private class_327 fontRenderer;
    private final KeybindingInfoStep keybindingInfoStep;
    private FullMapProperties fullMapProperties;
    private final class_310 mc;

    public KeybindingInfoLayer(Fullscreen fullscreen) {
        super(fullscreen);
        this.fontRenderer = class_310.method_1551().field_1772;
        this.fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        this.mc = class_310.method_1551();
        this.keybindingInfoStep = new KeybindingInfoStep();
        this.drawStepList.add(this.keybindingInfoStep);
    }

    @Override
    public List<DrawStep> onMouseMove(class_310 mc, Renderer renderer, Point2D.Double mousePosition, class_2338 blockPos, float fontScale, boolean isScrolling) {
        if (this.fullMapProperties.showKeys.get().booleanValue()) {
            if (this.keybindingInfoStep.panelRect.contains(mousePosition)) {
                this.keybindingInfoStep.hide();
            } else {
                this.keybindingInfoStep.show();
            }
            return this.drawStepList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<DrawStep> onMouseClick(class_310 mc, Renderer renderer, Point2D.Double mousePosition, class_2338 blockCoord, int button, boolean doubleClick, float fontScale) {
        return this.fullMapProperties.showKeys.get() != false ? this.drawStepList : Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class KeybindingInfoStep
    implements DrawStep {
        private double screenWidth;
        private double screenHeight;
        private double fontScale;
        private int pad;
        private ArrayList<class_3545<String, String>> lines;
        private int keyNameWidth = 0;
        private int keyDescWidth = 0;
        private int lineHeight = 0;
        Rectangle2D panelRect = new Rectangle2D.Double();
        Theme theme = ThemeLoader.getCurrentTheme();
        Theme.LabelSpec statusLabelSpec;
        int bgColor;
        float fgAlphaDefault = 1.0f;
        float bgAlphaDefault = 0.7f;
        float fgAlpha = this.fgAlphaDefault;
        float bgAlpha = this.bgAlphaDefault;

        KeybindingInfoStep() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && KeybindingInfoLayer.this.fullscreen.isButtonsVisable()) {
                if (KeybindingInfoLayer.this.fullscreen.getMenuToolbarBounds() == null) {
                    return;
                }
                this.updateLayout(renderer, fontScale);
                DrawUtil.drawRectangle(graphics, this.panelRect.getX(), this.panelRect.getY(), this.panelRect.getWidth(), this.panelRect.getHeight(), this.bgColor, this.bgAlpha);
                int x = (int)this.panelRect.getX() + this.pad + this.keyNameWidth;
                int y = (int)this.panelRect.getY() + this.pad;
                int firstColor = this.theme.fullscreen.statusLabel.highlight.getColor();
                int secondColor = this.theme.fullscreen.statusLabel.foreground.getColor();
                try {
                    RenderWrapper.enableBlend();
                    for (class_3545<String, String> line : this.lines) {
                        DrawUtil.drawLabel(graphics, (String)line.method_15442(), x, y, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, null, 0.0f, firstColor, this.fgAlpha, fontScale, false);
                        DrawUtil.drawLabel(graphics, (String)line.method_15441(), x + this.pad, y, DrawUtil.HAlign.Right, DrawUtil.VAlign.Middle, null, 0.0f, secondColor, this.fgAlpha, fontScale, false);
                        y += this.lineHeight;
                    }
                }
                finally {
                    RenderWrapper.disableBlend();
                }
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }

        void hide() {
            this.bgAlpha = 0.2f;
            this.fgAlpha = 0.2f;
        }

        void show() {
            this.bgAlpha = this.bgAlphaDefault;
            this.fgAlpha = this.fgAlphaDefault;
        }

        private void updateLayout(Renderer renderer, double fontScale) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.statusLabelSpec = theme.fullscreen.statusLabel;
            this.bgColor = this.statusLabelSpec.background.getColor();
            if (fontScale != this.fontScale || this.screenWidth != (double)renderer.getWidth() || this.screenHeight != (double)renderer.getHeight()) {
                this.screenWidth = renderer.getWidth();
                this.screenHeight = renderer.getHeight();
                this.fontScale = fontScale;
                this.pad = (int)(10.0 * fontScale);
                Objects.requireNonNull(KeybindingInfoLayer.this.fontRenderer);
                this.lineHeight = (int)(3.0 + fontScale * 9.0);
                this.initLines(fontScale);
                int panelWidth = this.keyNameWidth + this.keyDescWidth + 4 * this.pad;
                int panelHeight = this.lines.size() * this.lineHeight + this.pad;
                double scaleFactor = KeybindingInfoLayer.this.fullscreen.getScreenScaleFactor();
                double panelX = this.screenWidth - (double)theme.container.toolbar.vertical.margin * scaleFactor - (double)panelWidth;
                double panelY = this.screenHeight - (double)theme.container.toolbar.horizontal.margin * scaleFactor - (double)panelHeight;
                this.panelRect.setRect(panelX, panelY, panelWidth, panelHeight);
                Rectangle2D.Double menuToolbarRect = KeybindingInfoLayer.this.fullscreen.getMenuToolbarBounds();
                if (menuToolbarRect != null && menuToolbarRect.intersects(this.panelRect) && panelX <= menuToolbarRect.getMaxX()) {
                    panelY = (int)menuToolbarRect.getMinY() - 5 - panelHeight;
                    this.panelRect.setRect(panelX, panelY, panelWidth, panelHeight);
                }
            }
        }

        private void initLines(double fontScale) {
            this.lines = new ArrayList();
            this.keyDescWidth = 0;
            this.keyNameWidth = 0;
            this.bgAlpha = this.fgAlphaDefault;
            this.bgAlpha = this.bgAlphaDefault;
            for (UpdateAwareKeyBinding keyBinding : JourneymapClient.getInstance().getKeyEvents().getHandler().getInGuiKeybindings()) {
                this.initLine((class_304)keyBinding, fontScale);
            }
            this.initLine(KeybindingInfoLayer.this.mc.field_1690.field_1890, fontScale);
        }

        private void initLine(class_304 keyBinding, double fontScale) {
            String keyName = keyBinding.method_16007().getString().toUpperCase();
            String keyDesc = Constants.getString(keyBinding.method_1431());
            class_3545 line = new class_3545((Object)keyName, (Object)keyDesc);
            this.lines.add((class_3545<String, String>)line);
            this.keyNameWidth = (int)Math.max((double)this.keyNameWidth, fontScale * (double)KeybindingInfoLayer.this.fontRenderer.method_1727(keyName));
            this.keyDescWidth = (int)Math.max((double)this.keyDescWidth, fontScale * (double)KeybindingInfoLayer.this.fontRenderer.method_1727(keyDesc));
        }
    }
}

