/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymaptools;

import net.techbrew.journeymaptools.MapSaver;

public class Main {
    static String VERSION = "0.3";
    static String LOGFORMAT_PROP = "java.util.logging.SimpleFormatter.format";
    static String LOGFORMAT = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS [%4$s] %3$s:  %5$s%6$s%n";

    public static void main(String[] args) {
        String testLogFormat = System.getProperty(LOGFORMAT_PROP);
        if (testLogFormat == null || testLogFormat.equals("")) {
            System.setProperty(LOGFORMAT_PROP, LOGFORMAT);
        }
        System.out.println(String.format("\n== JourneyMapTools %s ==", VERSION));
        System.out.println("Use at your own risk. Always back up your files before use.\n");
        if (args.length > 0) {
            try {
                args[0] = args[0].toLowerCase();
                if (args[0].equals("mapsaver")) {
                    MapSaver.main(args);
                    return;
                }
                if (args[0].equals("mapmerger")) {
                    System.out.println("MapMerger: Coming Soon.");
                    return;
                }
            }
            catch (Throwable t) {
                System.err.println("Fatal error: " + t);
                t.printStackTrace(System.err);
            }
        }
        Main.showArgs();
    }

    public static void showArgs() {
        System.out.println("\t  MapSaver     Save all region tile images to a single file, with optional resizing.");
        System.out.println("\t  MapMerger    Merge tiles from two world directories.");
        System.out.println("\nRun the jar again with one of the above tool names (as the first argument) to get example usage.");
    }
}

