/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymaptools;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.techbrew.journeymaptools.MapType;
import net.techbrew.journeymaptools.PngjHelper;
import net.techbrew.journeymaptools.RegionCoord;

public class MapSaver {
    static Logger logger = Logger.getLogger(MapSaver.class.getSimpleName());
    final File worldDir;
    File saveFile;
    final Integer vSlice;
    final int dimension;
    final boolean showGrid;
    final int sourceTileSize;
    final int resultTileSize;
    long outputColumns;
    long outputRows;
    MapType mapType;
    ArrayList<File> files;
    boolean debug;

    public static void main(String[] args) throws Exception {
        MapType mapType;
        Boolean showGrid;
        Integer dimension;
        Integer vSlice;
        Integer resultTileSize;
        Integer sourceTileSize;
        File saveFile;
        File worldDir;
        if (args.length == 1) {
            MapSaver.showArgs();
            return;
        }
        boolean debug = false;
        try {
            int i = 1;
            worldDir = new File(args[i++]);
            saveFile = new File(args[i++]);
            sourceTileSize = Integer.parseInt(args[i++]);
            resultTileSize = Integer.parseInt(args[i++]);
            vSlice = Integer.parseInt(args[i++]);
            if (vSlice < 0) {
                vSlice = null;
            }
            dimension = Integer.parseInt(args[i++]);
            showGrid = Boolean.valueOf(args[i++]);
            mapType = MapType.valueOf(args[i++]);
            if (args.length - 1 == i) {
                debug = "debug".equals(args[i]);
            }
        }
        catch (Throwable t) {
            logger.severe(t.toString());
            MapSaver.showArgs();
            return;
        }
        MapSaver mapSaver = new MapSaver(worldDir, saveFile, sourceTileSize, resultTileSize, vSlice, dimension, mapType, showGrid, debug);
        mapSaver.saveMap();
    }

    public static void showArgs() {
        System.out.println("MapSaver Arguments:  \"<worldDir>\" \"<saveFileName>\" <sourceTileSize> <resultTileSize> <slice> <dimension> <showGrid> <mapType>");
        System.out.println("\t  \"<worldDir>\"        Path to data/sp/worldname");
        System.out.println("\t  \"<saveFileName>\"    Path of PNG image file to save.");
        System.out.println("\t  <sourceTileSize>    Current tile size. Unless you've resized them, use 512.");
        System.out.println("\t  <resultTileSize>    New tile size for output.  Use sourceTileSize to avoid resizing.");
        System.out.println("\t  <slice>             Vertical slice to map.  Use -1 for the surface in Overworld.");
        System.out.println("\t  <dimension>         Dimension ID.  1 for Nether, 0 for Overworld, 1 for End");
        System.out.println("\t  <showGrid>          Whether to add a grid overlay.  One of the following: true,false");
        System.out.println("\t  <mapType>           One of the following: day,night,underground. End/Nether require underground");
        System.out.println("\nExample Usage: MapSaver \"C:\\\\Game\\\\.minecraft\\\\journeyMap\\\\data\\\\sp\\\\MyWorld\" \"C:\\\\tmp\\\\MyWorld.png\" 512 512 -1 0 false day");
    }

    public MapSaver(File worldDir, File saveFile, int sourceTileSize, int resultTileSize, Integer vSlice, int dimension, MapType mapType, boolean showGrid, boolean debug) {
        this.worldDir = worldDir;
        this.saveFile = saveFile;
        this.sourceTileSize = sourceTileSize;
        this.resultTileSize = resultTileSize;
        this.vSlice = vSlice;
        this.dimension = dimension;
        this.showGrid = showGrid;
        this.mapType = mapType;
        this.debug = debug;
    }

    private boolean prepareFiles() {
        try {
            logger.info("Scanning for region tiles...");
            File imageDir = this.getImageDir();
            File[] pngFiles = imageDir.listFiles();
            if (pngFiles == null || pngFiles.length == 0) {
                logger.severe("Didn't find any PNG files in directory.");
                return false;
            }
            this.files = new ArrayList(pngFiles.length);
            Pattern tilePattern = Pattern.compile("([^\\.]+)\\,([^\\.]+)\\.png");
            Integer minX = null;
            Integer minZ = null;
            Integer maxX = null;
            Integer maxZ = null;
            for (File file : pngFiles) {
                Matcher matcher = tilePattern.matcher(file.getName());
                if (!matcher.matches()) continue;
                this.files.add(file);
                Integer x = Integer.parseInt(matcher.group(1));
                Integer z = Integer.parseInt(matcher.group(2));
                if (minX == null || x < minX) {
                    minX = x;
                }
                if (minZ == null || z < minZ) {
                    minZ = z;
                }
                if (maxX == null || x > maxX) {
                    maxX = x;
                }
                if (maxZ != null && z <= maxZ) continue;
                maxZ = z;
            }
            if (this.files.size() == 0 || minX == null || maxX == null || minZ == null || maxZ == null) {
                logger.severe("No region files to save in " + imageDir);
                return false;
            }
            int count = this.files.size();
            this.outputColumns = maxX - minX + 1;
            this.outputRows = maxZ - minZ + 1;
            logger.info(String.format("Region bounds found: [%d,%s] to [%d,%s], resulting in %d columns by %d rows ", minX, minZ, maxX, maxZ, this.outputColumns, this.outputRows));
            if (this.outputColumns < 1L || this.outputRows < 1L) {
                logger.severe("One or more region file names is incorrect. Aborting.");
                return false;
            }
            if (this.outputColumns > 62500L || this.outputRows > 62500L) {
                logger.severe("Check for and remove region files with significantly high/low numbers.");
                logger.severe("The area to map exceeds 32,000,000 blocks. Aborting.");
                return false;
            }
            long blanks = this.outputColumns * this.outputRows - (long)count;
            logger.info(String.format("%d Region tiles found. %d blank tiles will be added to fill gaps.", count, blanks));
            if (blanks > (long)count) {
                logger.warning("WARNING! The blank areas exceed the mapped ones. Check for and remove region files with significantly high/low numbers.");
            }
            this.files.clear();
            for (int rz = minZ.intValue(); rz <= maxZ; ++rz) {
                for (int rx = minX.intValue(); rx <= maxX; ++rx) {
                    RegionCoord rc = new RegionCoord(this.worldDir, rx, this.vSlice, rz, this.dimension);
                    File rfile = MapSaver.getRegionImageFile(rc, this.mapType);
                    if (!rfile.canRead()) {
                        this.files.add(MapSaver.getBlankImageFile(this.sourceTileSize));
                        continue;
                    }
                    this.files.add(rfile);
                }
            }
            logger.info(String.format("\tTotal area is %d regions wide by %d regions high (%d chunks x %d chunks)", this.outputColumns, this.outputRows, this.outputColumns * 512L / 16L, this.outputRows * 512L / 16L));
            logger.info(String.format("\tCombined tile images equal to: %d px x %d px", this.outputColumns * (long)this.sourceTileSize, this.outputRows * (long)this.sourceTileSize));
            if (this.sourceTileSize != this.resultTileSize) {
                logger.info(String.format("\tResulting map image will be:   %d px x %d px", this.outputColumns * (long)this.resultTileSize, this.outputRows * (long)this.resultTileSize));
            }
            return true;
        }
        catch (Throwable t) {
            logger.severe("Error preparing files: " + t);
            t.printStackTrace(System.err);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File saveMap() {
        long start = System.currentTimeMillis();
        if (!this.prepareFiles()) {
            return null;
        }
        try {
            File[] fileArray = this.files.toArray(new File[this.files.size()]);
            PngjHelper.mergeFiles(fileArray, this.saveFile, (int)this.outputColumns, this.sourceTileSize, this.resultTileSize, this.showGrid);
            logger.info("Map saved: " + this.saveFile.getCanonicalPath());
        }
        catch (OutOfMemoryError e) {
            logger.severe("Out Of Memory");
            long millis = System.currentTimeMillis() - start;
            long ms = millis % 1000L;
            int secs = (int)(millis / 1000L % 60L);
            int mins = (int)(millis / 1000L / 60L);
            logger.info(String.format("Elapsed: %d min, %d sec, %dms", mins, secs, ms));
        }
        catch (Throwable t) {
            logger.severe(t.toString());
            File file = null;
            {
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - start;
                    long ms = millis % 1000L;
                    int secs = (int)(millis / 1000L % 60L);
                    int mins = (int)(millis / 1000L / 60L);
                    logger.info(String.format("Elapsed: %d min, %d sec, %dms", mins, secs, ms));
                    throw throwable;
                }
            }
            long millis2 = System.currentTimeMillis() - start;
            long ms2 = millis2 % 1000L;
            int secs2 = (int)(millis2 / 1000L % 60L);
            int mins2 = (int)(millis2 / 1000L / 60L);
            logger.info(String.format("Elapsed: %d min, %d sec, %dms", mins2, secs2, ms2));
            return file;
        }
        long millis = System.currentTimeMillis() - start;
        long ms = millis % 1000L;
        int secs = (int)(millis / 1000L % 60L);
        int mins = (int)(millis / 1000L / 60L);
        logger.info(String.format("Elapsed: %d min, %d sec, %dms", mins, secs, ms));
        return this.saveFile;
    }

    private File getImageDir() {
        RegionCoord fakeRc = new RegionCoord(this.worldDir, 0, this.vSlice, 0, this.dimension);
        return MapSaver.getImageDir(fakeRc, this.mapType);
    }

    public static File getImageDir(RegionCoord rCoord, MapType mapType) {
        File dimDir = new File(rCoord.worldDir, "DIM" + rCoord.dimension);
        File subDir = null;
        subDir = rCoord.isUnderground() != false ? new File(dimDir, Integer.toString(rCoord.getVerticalSlice())) : new File(dimDir, mapType.name());
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        return subDir;
    }

    public static File getRegionImageFile(RegionCoord rCoord, MapType mapType) {
        StringBuffer sb = new StringBuffer();
        sb.append(rCoord.regionX).append(",").append(rCoord.regionZ).append(".png");
        File regionFile = new File(MapSaver.getImageDir(rCoord, mapType), sb.toString());
        return regionFile;
    }

    public static BufferedImage createBlankImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2D = img.createGraphics();
        return img;
    }

    public static File getBlankImageFile(int size) {
        File tmpFile = new File(".", String.format("blank%spx.png", size));
        if (!tmpFile.canRead()) {
            BufferedImage image = MapSaver.createBlankImage(size, size);
            try {
                tmpFile.getParentFile().mkdirs();
                ImageIO.write((RenderedImage)image, "png", tmpFile);
                tmpFile.setReadOnly();
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return tmpFile;
    }
}

