/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymaptools;

import ar.com.hjg.pngj.FileHelper;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngReader;
import ar.com.hjg.pngj.PngWriter;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class PngjHelper {
    static Logger logger = Logger.getLogger(PngjHelper.class.getSimpleName());

    public static void mergeFiles(File[] sourceFiles, File destFile, int tileColumns, int sourceSize, int tileSize, boolean showGrid) {
        int ntiles = sourceFiles.length;
        int tileRows = (ntiles + tileColumns - 1) / tileColumns;
        PngReader[] readers = new PngReader[tileColumns];
        ImageInfo destImgInfo = new ImageInfo(tileSize * tileColumns, tileSize * tileRows, 8, true);
        PngWriter pngw = FileHelper.createPngWriter(destFile, destImgInfo, true);
        pngw.getMetadata().setText("Author", "JourneyMap");
        pngw.getMetadata().setText("Comment", "http://journeymaptools.techbrew.net");
        ImageLine destLine = new ImageLine(destImgInfo, ImageLine.SampleType.INT, false);
        int lineLen = tileSize * 4;
        int gridColor = 135;
        int destRow = 0;
        for (int ty = 0; ty < tileRows; ++ty) {
            int tx;
            logger.info(String.format("Processing row %d of %d...", ty + 1, tileRows));
            int nTilesXcur = ty < tileRows - 1 ? tileColumns : ntiles - (tileRows - 1) * tileColumns;
            Arrays.fill(destLine.scanline, 0);
            for (tx = 0; tx < nTilesXcur; ++tx) {
                File sourceFile = sourceFiles[tx + ty * tileColumns];
                readers[tx] = PngjHelper.getReader(sourceFile, sourceSize, tileSize);
                readers[tx].setChunkLoadBehaviour(ChunkLoadBehaviour.LOAD_CHUNK_NEVER);
                readers[tx].setUnpackedMode(false);
            }
            int srcRow = 0;
            block4: while (srcRow < tileSize) {
                for (int tx2 = 0; tx2 < nTilesXcur; ++tx2) {
                    ImageLine srcLine = readers[tx2].readRowInt(srcRow);
                    int[] src = srcLine.scanline;
                    if (showGrid) {
                        int skip = srcRow % 16 == 0 ? 4 : 64;
                        for (int i = 0; i <= src.length - skip; i += skip) {
                            src[i] = (src[i] + src[i] + 135) / 3;
                            src[i + 1] = (src[i + 1] + src[i + 1] + 135) / 3;
                            src[i + 2] = (src[i + 2] + src[i + 2] + 135) / 3;
                            src[i + 3] = 255;
                        }
                    }
                    int[] dest = destLine.scanline;
                    int destPos = lineLen * tx2;
                    try {
                        System.arraycopy(src, 0, dest, destPos, lineLen);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.severe("Bad image data. Src len=" + src.length + ", dest len=" + dest.length + ", destPos=" + destPos);
                        break block4;
                    }
                }
                pngw.writeRow(destLine, destRow);
                ++srcRow;
                ++destRow;
            }
            for (tx = 0; tx < nTilesXcur; ++tx) {
                readers[tx].end();
            }
        }
        pngw.end();
    }

    private static PngReader getReader(File sourceFile, int sourceSize, int tileSize) {
        if (sourceSize == tileSize) {
            return FileHelper.createPngReader(sourceFile);
        }
        BufferedImage source = null;
        try {
            source = ImageIO.read(sourceFile);
        }
        catch (IOException e) {
            logger.severe("Corrupt or unreadable image file: " + sourceFile);
            throw new RuntimeException(e);
        }
        BufferedImage out = new BufferedImage(tileSize, tileSize, source.getType());
        Graphics2D g2D = out.createGraphics();
        if (tileSize < sourceSize) {
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2D.drawImage(source, 0, 0, tileSize, tileSize, null);
        g2D.dispose();
        ByteArrayOutputStream output = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        try {
            ImageIO.write((RenderedImage)out, "png", output);
        }
        catch (IOException e) {
            logger.severe("Couldn't resize image: " + sourceFile);
            e.printStackTrace();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(output.toByteArray(), 0, output.size());
        return new PngReader(inputStream, sourceFile.getName());
    }
}

