/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymaptools;

import java.io.File;

public class RegionCoord
implements Comparable<RegionCoord> {
    public final File worldDir;
    public final int regionX;
    public final int regionZ;
    public final Integer vSlice;
    public final int dimension;

    public RegionCoord(File worldDir, int regionX, Integer vSlice, int regionZ, int dimension) {
        this.worldDir = worldDir;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.vSlice = vSlice;
        this.dimension = dimension;
    }

    public Boolean isUnderground() {
        return this.vSlice != null ? this.vSlice != -1 : false;
    }

    public Integer getVerticalSlice() {
        if (this.vSlice == null) {
            return -1;
        }
        return this.vSlice;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getVerticalSlice();
        result = 31 * result + this.regionX;
        result = 31 * result + this.regionZ;
        result = 31 * result + (this.worldDir == null ? 0 : this.worldDir.hashCode());
        result = 31 * result + this.dimension;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionCoord other = (RegionCoord)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.regionX != other.regionX) {
            return false;
        }
        if (this.regionZ != other.regionZ) {
            return false;
        }
        if (other.getVerticalSlice() != this.getVerticalSlice()) {
            return false;
        }
        return !(this.worldDir == null ? other.worldDir != null : !this.worldDir.equals(other.worldDir));
    }

    @Override
    public int compareTo(RegionCoord o) {
        int cx = Double.compare(this.regionX, o.regionX);
        return cx == 0 ? Double.compare(this.regionZ, o.regionZ) : cx;
    }
}

