/*
 * Decompiled with CFR 0.152.
 */
package net.literally.chunk.loader.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.literally.chunk.loader.data.SerializableChunkPos;
import net.literally.chunk.loader.entity.ChunkLoaderBlockEntity;
import net.literally.chunk.loader.initializer.LCLItems;
import net.literally.chunk.loader.initializer.LCLPersistentChunks;
import net.literally.chunk.loader.network.packets.packet.ForcedChunksUpdatePacketPayload;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderBlock
extends class_2237 {
    public static final class_2960 ID = class_2960.method_60655((String)"lchunkloader", (String)"chunk_loader");
    public static final class_2754<class_2350> FACING = class_2383.field_11177;

    public ChunkLoaderBlock() {
        super(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)ID)).method_9626(class_2498.field_11533).method_9629(1.0f, 1.0f).method_22488());
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043));
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        return class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        player.method_17355(state.method_26196(world, pos));
        if (!world.field_9236) {
            class_3218 serverWorld = (class_3218)world;
            LongSet set = serverWorld.method_17984();
            ArrayList<SerializableChunkPos> longs = new ArrayList<SerializableChunkPos>();
            SerializableChunkPos chunk = new SerializableChunkPos(pos, world.method_27983().method_29177().method_12832());
            LongIterator longIterator = set.iterator();
            while (longIterator.hasNext()) {
                long longPos = (Long)longIterator.next();
                int fromX = chunk.getX() - 2;
                int toX = chunk.getX() + 2;
                int fromZ = chunk.getZ() - 2;
                int toZ = chunk.getZ() + 2;
                int x = class_1923.method_8325((long)longPos);
                int z = class_1923.method_8332((long)longPos);
                if (x < fromX || x > toX || z < fromZ || z > toZ) continue;
                longs.add(new SerializableChunkPos(longPos, chunk.getDimension()));
            }
            ForcedChunksUpdatePacketPayload pack = new ForcedChunksUpdatePacketPayload(chunk.getX(), chunk.getZ(), true, longs);
            pack.sendTo(player);
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236) {
            SerializableChunkPos chunk = new SerializableChunkPos(pos, world.method_27983().method_29177().method_12832());
            LCLPersistentChunks.loaderRemoved(world.method_8503(), chunk);
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        if (!world.field_9236) {
            MinecraftServer server = world.method_8503();
            SerializableChunkPos chunk = new SerializableChunkPos(pos, world.method_27983().method_29177().method_12832());
            boolean canPlace = LCLPersistentChunks.canPlaceLoaderAt(chunk);
            if (canPlace) {
                LCLPersistentChunks.loaderAdded(chunk);
            } else {
                class_1657 player = (class_1657)placer;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)new class_1277(new class_1799[]{new class_1799((class_1935)LCLItems.CHUNKLOADERITEM, 1)}));
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                if (server == null) {
                    return;
                }
                class_3222 manager = server.method_3760().method_14602(player.method_5667());
                if (manager == null) {
                    return;
                }
                manager.method_64398(class_2561.method_30163((String)"Can't place a Loader in the same chunk of another Loader"));
                return;
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        double d = (double)pos.method_10263() + 0.65 - (double)(random.method_43057() * 0.3f);
        double e = (double)pos.method_10264() + 1.0 - (double)(random.method_43057() * 0.5f);
        double f = (double)pos.method_10260() + 0.65 - (double)(random.method_43057() * 0.3f);
        double g = 0.4f - (random.method_43057() + random.method_43057()) * 0.4f;
        if (random.method_43048(6) == 0) {
            world.method_8406((class_2394)class_2398.field_11207, d + (double)0.1f * g, e + (double)0.1f * g, f + (double)0.1f * g, random.method_43059() * 0.005, random.method_43059() * 0.005, random.method_43059() * 0.005);
        }
        double x = (double)pos.method_10263() + 0.65 - (double)(random.method_43057() * 0.3f);
        double y = (double)pos.method_10264() + 2.75;
        double z = (double)pos.method_10260() + 0.65 - (double)(random.method_43057() * 0.3f);
        world.method_8406((class_2394)class_2398.field_11214, x, y, z, 0.0, -3.0, 0.0);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ChunkLoaderBlockEntity(pos, state);
    }
}

