/*
 * Decompiled with CFR 0.152.
 */
package net.literally.chunk.loader.data;

import java.io.Serializable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_5321;

public class SerializableChunkPos
implements Serializable {
    private final int x;
    private final int z;
    private final String dimension;

    public SerializableChunkPos(class_2338 origin, String dimension) {
        this((float)origin.method_10263(), (float)origin.method_10260(), dimension);
    }

    public SerializableChunkPos(long pos, String dimension) {
        this((int)pos, (int)(pos >> 32), dimension);
    }

    public SerializableChunkPos(float blockX, float blockZ, String dimension) {
        this((int)blockX >> 4, (int)blockZ >> 4, dimension);
    }

    public SerializableChunkPos(int x, int z, String dimension) {
        this.x = x;
        this.z = z;
        this.dimension = dimension;
    }

    public static SerializableChunkPos read(class_2540 buf) {
        int x = buf.readInt();
        int z = buf.readInt();
        String dimension = buf.method_10800(Short.MAX_VALUE);
        return new SerializableChunkPos(x, z, dimension);
    }

    public float distanceFrom(SerializableChunkPos pos) {
        float firstSq = Math.abs(pos.getX() - this.getX());
        float secSq = Math.abs(pos.getZ() - this.getZ());
        return (float)Math.sqrt(firstSq * firstSq + secSq * secSq);
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getZ() + "] in " + this.dimension;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializableChunkPos) {
            SerializableChunkPos other = (SerializableChunkPos)obj;
            return this.getDimension().equals(other.getDimension()) && this.x == other.getX() && this.z == other.getZ();
        }
        return super.equals(obj);
    }

    public void writeTo(class_2540 buf) {
        buf.method_53002(this.x);
        buf.method_53002(this.z);
        buf.method_10814(this.dimension);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public SerializableChunkPos getChunkAtRelativeOffset(int i, int j) {
        return new SerializableChunkPos(this.getWorldRelativeX(i), this.getWorldRelativeZ(j), this.getDimension());
    }

    public int getWorldRelativeX(int index) {
        return this.x - 2 + index;
    }

    public int getWorldRelativeZ(int index) {
        return this.z - 2 + index;
    }

    public String getDimension() {
        return this.dimension;
    }

    public class_5321<class_1937> getDimensionRegistryKey() {
        if (this.dimension.equals(class_1937.field_25179.method_29177().method_12832())) {
            return class_1937.field_25179;
        }
        if (this.dimension.equals(class_1937.field_25180.method_29177().method_12832())) {
            return class_1937.field_25180;
        }
        if (this.dimension.equals(class_1937.field_25181.method_29177().method_12832())) {
            return class_1937.field_25181;
        }
        return null;
    }
}

