/*
 * Decompiled with CFR 0.152.
 */
package net.literally.chunk.loader.gui.handler;

import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.literally.chunk.loader.data.SerializableChunkPos;
import net.literally.chunk.loader.initializer.LCLBlocks;
import net.literally.chunk.loader.initializer.LCLGUIHandlers;
import net.literally.chunk.loader.network.packets.packet.ForcedChunksUpdatePacketPayload;
import net.literally.chunk.loader.utils.ModLogger;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3914;
import net.minecraft.class_8710;

public class ChunkLoaderGUIHandler
extends SyncedGuiDescription {
    class_2338 pos;
    WToggleButton[][] buttonsMatrix;
    SerializableChunkPos centre;
    class_3914 context;

    public ChunkLoaderGUIHandler(int syncId, class_1661 playerInventory, class_3914 context, class_2338 pos) {
        super(LCLGUIHandlers.CHUNK_LOADER_SCREEN_HANDLER, syncId, playerInventory, ChunkLoaderGUIHandler.getBlockInventory((class_3914)context), null);
        this.context = context;
        this.pos = pos;
        this.centre = new SerializableChunkPos(pos, this.world.method_27983().method_29177().method_12832());
        WPlainPanel root = new WPlainPanel();
        root.setSize(128, 140);
        root.setInsets(Insets.ROOT_PANEL);
        this.setupButtonsGrid(root);
        WButton selectAll = new WButton(class_2561.method_30163((String)"All"));
        selectAll.setOnClick(() -> {
            ArrayList<SerializableChunkPos> data = new ArrayList<SerializableChunkPos>();
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    data.add(this.centre.getChunkAtRelativeOffset(i, j));
                }
            }
            ForcedChunksUpdatePacketPayload pack = new ForcedChunksUpdatePacketPayload(pos.method_10263(), pos.method_10260(), true, data);
            ClientPlayNetworking.send((class_8710)pack);
        });
        WButton selectNone = new WButton(class_2561.method_30163((String)"None"));
        selectNone.setOnClick(() -> {
            ArrayList<SerializableChunkPos> data = new ArrayList<SerializableChunkPos>();
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    data.add(this.centre.getChunkAtRelativeOffset(i, j));
                }
            }
            ForcedChunksUpdatePacketPayload pack = new ForcedChunksUpdatePacketPayload(pos.method_10263(), pos.method_10260(), false, data);
            ClientPlayNetworking.send((class_8710)pack);
        });
        root.add((WWidget)selectAll, 16, 128, 40, 24);
        root.add((WWidget)selectNone, 71, 128, 40, 24);
        this.setRootPanel((WPanel)root);
    }

    public boolean method_7597(class_1657 entity) {
        return ChunkLoaderGUIHandler.method_17695((class_3914)this.context, (class_1657)entity, (class_2248)LCLBlocks.CHUNK_LOADER_BLOCK);
    }

    public void refreshGUI(ForcedChunksUpdatePacketPayload payload) {
        List<SerializableChunkPos> chunks = payload.getChunksPos();
        if (!chunks.isEmpty()) {
            if (!chunks.getFirst().getDimension().equals(this.centre.getDimension())) {
                ModLogger.DEFAULT_CHANNEL.logInfo("not calculating, other dim");
                return;
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    if (!chunks.contains(this.centre.getChunkAtRelativeOffset(i, j))) continue;
                    this.buttonsMatrix[i][j].setToggle(payload.isState());
                }
            }
        }
    }

    private void setupButtonsGrid(WPlainPanel root) {
        WLabel north = new WLabel(class_2561.method_30163((String)"N"));
        north.setHorizontalAlignment(HorizontalAlignment.CENTER);
        north.setVerticalAlignment(VerticalAlignment.CENTER);
        WLabel south = new WLabel(class_2561.method_30163((String)"S"));
        south.setHorizontalAlignment(HorizontalAlignment.CENTER);
        south.setVerticalAlignment(VerticalAlignment.CENTER);
        WLabel east = new WLabel(class_2561.method_30163((String)"E"));
        east.setHorizontalAlignment(HorizontalAlignment.CENTER);
        east.setVerticalAlignment(VerticalAlignment.CENTER);
        WLabel west = new WLabel(class_2561.method_30163((String)"W"));
        west.setHorizontalAlignment(HorizontalAlignment.CENTER);
        west.setVerticalAlignment(VerticalAlignment.CENTER);
        this.buttonsMatrix = new WToggleButton[5][5];
        for (int i = 0; i < 5; ++i) {
            int posX = 19 * i + 16;
            for (int j = 0; j < 5; ++j) {
                WToggleButton curr = new WToggleButton(class_2960.method_60654((String)"lchunkloader:textures/gui/loaded.png"), class_2960.method_60654((String)"lchunkloader:textures/gui/not_loaded.png"));
                int finalI = i;
                int finalJ = j;
                curr.setOnToggle(state -> {
                    ForcedChunksUpdatePacketPayload pack = new ForcedChunksUpdatePacketPayload(this.pos.method_10263(), this.pos.method_10260(), (boolean)state, Collections.singletonList(this.centre.getChunkAtRelativeOffset(finalI, finalJ)));
                    ClientPlayNetworking.send((class_8710)pack);
                });
                int posY = 19 * j + 16;
                root.add((WWidget)curr, posX, posY, 16, 16);
                this.buttonsMatrix[i][j] = curr;
            }
        }
        root.add((WWidget)north, 54, 2, 16, 16);
        root.add((WWidget)south, 54, 109, 16, 16);
        root.add((WWidget)west, 2, 54, 16, 16);
        root.add((WWidget)east, 109, 54, 16, 16);
    }
}

