/*
 * Decompiled with CFR 0.152.
 */
package net.literally.chunk.loader.initializer;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.literally.chunk.loader.data.LCLData;
import net.literally.chunk.loader.data.SerializableChunkPos;
import net.literally.chunk.loader.saves.ChunksSerializeManager;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public final class LCLCommands {
    public static void initialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> LCLLocate.define((CommandDispatcher<class_2168>)dispatcher));
    }

    private static final class LCLLocate {
        private LCLLocate() {
        }

        public static void define(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"lclocate").then(class_2170.method_9244((String)"dimension", (ArgumentType)StringArgumentType.word()).suggests(LCLLocate.suggestedStrings()).executes(ctx -> {
                String dimension = StringArgumentType.getString((CommandContext)ctx, (String)"dimension");
                ArrayList<SerializableChunkPos> loaders = LCLLocate.getLoadersInDimension((CommandContext<class_2168>)ctx, dimension);
                if (loaders.isEmpty()) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)("No loaders found in dimension: " + dimension + "\n")), false);
                    return 1;
                }
                int size = loaders.size();
                StringBuilder response = new StringBuilder("Found " + size + " placed loaders ");
                if (!dimension.equals("all")) {
                    response.append("in dimension: ").append(dimension).append("\n");
                } else {
                    response.append(": \n");
                }
                for (int i = 0; i < size; ++i) {
                    SerializableChunkPos current = loaders.get(i);
                    response.append("[").append(current.getX()).append(", ").append(current.getZ()).append("]");
                    if (dimension.equals("all")) {
                        response.append(" in ").append(current.getDimension());
                    }
                    if (i >= size - 1) continue;
                    response.append(", ");
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)response.toString()), false);
                return 1;
            })));
        }

        public static SuggestionProvider<class_2168> suggestedStrings() {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add(class_1937.field_25179.method_29177().method_12832());
            suggestions.add(class_1937.field_25180.method_29177().method_12832());
            suggestions.add(class_1937.field_25181.method_29177().method_12832());
            suggestions.add("all");
            return (ctx, builder) -> LCLLocate.getSuggestionsBuilder(builder, suggestions);
        }

        private static CompletableFuture<Suggestions> getSuggestionsBuilder(SuggestionsBuilder builder, List<String> list) {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            if (list.isEmpty()) {
                return Suggestions.empty();
            }
            for (String str : list) {
                if (!str.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
                builder.suggest(str);
            }
            return builder.buildFuture();
        }

        private static ArrayList<SerializableChunkPos> getLoadersInDimension(CommandContext<class_2168> ctx, String dimension) {
            ArrayList<SerializableChunkPos> res = new ArrayList<SerializableChunkPos>();
            LCLData areasData = ChunksSerializeManager.deserialize(((class_2168)ctx.getSource()).method_9225().method_8503().method_27728().method_150());
            if (areasData == null) {
                return res;
            }
            ArrayList<SerializableChunkPos> all = areasData.getLoadersChunks();
            if (dimension.equals("all")) {
                return all;
            }
            for (SerializableChunkPos chunk : all) {
                if (!chunk.getDimension().equals(dimension)) continue;
                res.add(chunk);
            }
            return res;
        }
    }
}

