/*
 * Decompiled with CFR 0.152.
 */
package net.literally.chunk.loader.initializer;

import java.util.ArrayList;
import net.literally.chunk.loader.data.LCLData;
import net.literally.chunk.loader.data.SerializableChunkPos;
import net.literally.chunk.loader.saves.ChunksSerializeManager;
import net.literally.chunk.loader.utils.ModLogger;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class LCLPersistentChunks {
    public static String CURRENT_LEVEL_NAME;
    private static LCLData data;

    public static void initialize(MinecraftServer server) {
        CURRENT_LEVEL_NAME = server.method_27728().method_150();
        LCLPersistentChunks.initializeForcedChunks(server);
    }

    public static void loaderRemoved(MinecraftServer server, SerializableChunkPos chunk) {
        data.removeLoaderPos(chunk);
        LCLPersistentChunks.resetLoaderArea(server, chunk);
        LCLPersistentChunks.save();
    }

    private static void resetLoaderArea(MinecraftServer server, SerializableChunkPos chunk) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                LCLPersistentChunks.forceLoadChunk(server, chunk.getChunkAtRelativeOffset(i, j), false);
            }
        }
    }

    public static boolean loaderAdded(SerializableChunkPos chunk) {
        data.addLoaderPos(chunk);
        return LCLPersistentChunks.save();
    }

    public static void forceLoadChunk(MinecraftServer server, SerializableChunkPos chunk, boolean state) {
        data.chunkForceLoaded(chunk, state);
        LCLPersistentChunks.setChunkForceLoaded(server, chunk, state);
    }

    public static boolean canPlaceLoaderAt(SerializableChunkPos chunk) {
        return !data.isLoaderPresentAt(chunk);
    }

    private static void initializeForcedChunks(MinecraftServer server) {
        ModLogger logger = ModLogger.DEFAULT_CHANNEL;
        data = ChunksSerializeManager.deserialize(server.method_27728().method_150());
        if (data == null) {
            data = new LCLData();
            LCLPersistentChunks.save();
        } else {
            logger.logInfo("initializing: " + data.getChunks().size() + " force loaded chunks");
            logger.logInfo("found: " + data.getLoadersChunks().size() + " Loaders placed");
            ArrayList<SerializableChunkPos> chunks = data.getChunks();
            for (SerializableChunkPos chunk : chunks) {
                LCLPersistentChunks.setChunkForceLoaded(server, chunk, true);
            }
        }
    }

    private static void setChunkForceLoaded(MinecraftServer server, SerializableChunkPos chunk, boolean state) {
        boolean res;
        if (chunk == null) {
            return;
        }
        ModLogger logger = ModLogger.DEFAULT_CHANNEL;
        class_3218 serverWorld = server.method_3847(chunk.getDimensionRegistryKey());
        if (serverWorld == null) {
            return;
        }
        if (chunk.getX() >= -30000000 && chunk.getZ() >= -30000000 && chunk.getX() < 30000000 && chunk.getZ() < 30000000 && (res = serverWorld.method_17988(chunk.getX(), chunk.getZ(), state))) {
            logger.logInfo("setting chunk: " + String.valueOf(chunk) + " forceloaded = " + state);
        }
    }

    public static boolean save() {
        return ChunksSerializeManager.serialize(data, CURRENT_LEVEL_NAME);
    }
}

