/*
 * Decompiled with CFR 0.152.
 */
package net.literally.chunk.loader.network.packets.packet;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.literally.chunk.loader.data.SerializableChunkPos;
import net.literally.chunk.loader.gui.handler.ChunkLoaderGUIHandler;
import net.literally.chunk.loader.initializer.LCLPersistentChunks;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record ForcedChunksUpdatePacketPayload(int x, int z, boolean state, List<SerializableChunkPos> chunksPos) implements class_8710
{
    public static final class_8710.class_9154<ForcedChunksUpdatePacketPayload> ID = class_8710.method_56483((String)"lclpacket");
    public static final class_9139<class_2540, ForcedChunksUpdatePacketPayload> CODEC = class_9139.method_56438(ForcedChunksUpdatePacketPayload::write, ForcedChunksUpdatePacketPayload::read);

    public static ForcedChunksUpdatePacketPayload read(class_2540 buf) {
        ArrayList<SerializableChunkPos> chunks = new ArrayList<SerializableChunkPos>();
        int x = buf.readInt();
        int z = buf.readInt();
        boolean state = buf.readBoolean();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            chunks.add(SerializableChunkPos.read(buf));
        }
        return new ForcedChunksUpdatePacketPayload(x, z, state, chunks);
    }

    public void write(class_2540 buf) {
        buf.method_53002(this.getX());
        buf.method_53002(this.getZ());
        buf.method_52964(this.isState());
        int size = this.getChunksPos().size();
        buf.method_53002(size);
        for (SerializableChunkPos chunkPos : this.getChunksPos()) {
            chunkPos.writeTo(buf);
        }
    }

    public void onClientReceive(class_310 client) {
        client.execute(() -> {
            class_746 player = class_310.method_1551().field_1724;
            assert (player != null);
            class_1703 screenHandler = player.field_7512;
            if (screenHandler != null && screenHandler instanceof ChunkLoaderGUIHandler) {
                ChunkLoaderGUIHandler clHandler = (ChunkLoaderGUIHandler)screenHandler;
                clHandler.refreshGUI(this);
            }
        });
    }

    public void sendTo(class_1657 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.write(buf);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)this);
    }

    public void onServerReceive(MinecraftServer server) {
        for (SerializableChunkPos chunksPo : this.getChunksPos()) {
            LCLPersistentChunks.forceLoadChunk(server, chunksPo, this.isState());
        }
        List targets = server.method_3760().method_14571();
        for (class_3222 target : targets) {
            this.sendTo((class_1657)target);
        }
    }

    public List<SerializableChunkPos> getChunksPos() {
        return this.chunksPos;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isState() {
        return this.state;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

