/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsnowy.teleport_commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.mrsnowy.teleport_commands.commands.back;
import dev.mrsnowy.teleport_commands.commands.home;
import dev.mrsnowy.teleport_commands.commands.tpa;
import dev.mrsnowy.teleport_commands.commands.warp;
import dev.mrsnowy.teleport_commands.commands.worldspawn;
import dev.mrsnowy.teleport_commands.storage.StorageManager;
import dev.mrsnowy.teleport_commands.utils.tools;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeleportCommands {
    public static final String MOD_ID = "teleport_commands";
    public static final String MOD_NAME = "Teleport Commands";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Teleport Commands");
    public static String MOD_LOADER;
    public static Path SAVE_DIR;
    public static Path CONFIG_DIR;
    public static MinecraftServer SERVER;

    public static void initializeMod(MinecraftServer server) {
        LOGGER.info("Initializing Teleport Commands! Hello {}!", (Object)MOD_LOADER);
        SAVE_DIR = Path.of(String.valueOf(server.method_27050(class_5218.field_24188)), new String[0]);
        CONFIG_DIR = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("config");
        SERVER = server;
        TeleportCommands.cleanStorage();
        class_2170 commandManager = server.method_3734();
        back.register(commandManager);
        home.register(commandManager);
        tpa.register(commandManager);
        warp.register(commandManager);
        worldspawn.register(commandManager);
    }

    public static void onPlayerDeath(class_3222 player) {
        try {
            tools.DeathLocationUpdater(new class_2338(player.method_31477(), player.method_31478(), player.method_31479()), player.method_51469(), player.method_5845());
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
    }

    private static void cleanStorage() {
        LOGGER.info("Cleaning and updating Storage!");
        try {
            StorageManager.StorageInit();
            long startFileSize = Files.size(StorageManager.STORAGE_FILE);
            FileReader reader = new FileReader(StorageManager.STORAGE_FILE.toString());
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement.isJsonObject()) {
                JsonObject mainJsonObject = jsonElement.getAsJsonObject();
                JsonArray newWarpsArray = new JsonArray();
                JsonArray newPlayersArray = new JsonArray();
                if (mainJsonObject.has("Warps") && mainJsonObject.get("Warps").isJsonArray()) {
                    for (JsonElement warpElement : mainJsonObject.get("Warps").getAsJsonArray()) {
                        String warpWorld;
                        if (!warpElement.isJsonObject()) continue;
                        JsonObject warp2 = warpElement.getAsJsonObject();
                        String warpName = warp2.has("name") ? warp2.get("name").getAsString() : "";
                        Integer warpX = warp2.has("x") ? Integer.valueOf(warp2.get("x").getAsInt()) : null;
                        Integer warpY = warp2.has("y") ? Integer.valueOf(warp2.get("y").getAsInt()) : null;
                        Integer warpZ = warp2.has("z") ? Integer.valueOf(warp2.get("z").getAsInt()) : null;
                        String string = warpWorld = warp2.has("world") ? warp2.get("world").getAsString() : "";
                        if (warpName.isBlank() || warpWorld.isBlank() || warpX == null || warpY == null || warpZ == null) continue;
                        JsonObject newWarp = new JsonObject();
                        newWarp.addProperty("name", warpName);
                        newWarp.addProperty("x", (Number)warpX);
                        newWarp.addProperty("y", (Number)warpY);
                        newWarp.addProperty("z", (Number)warpZ);
                        newWarp.addProperty("world", warpWorld);
                        newWarpsArray.add((JsonElement)newWarp);
                    }
                }
                if (mainJsonObject.has("Players") && mainJsonObject.get("Players").isJsonArray()) {
                    for (JsonElement playerElement : mainJsonObject.get("Players").getAsJsonArray()) {
                        if (!playerElement.isJsonObject()) continue;
                        JsonObject player = playerElement.getAsJsonObject();
                        boolean hasInformation = false;
                        String UUID = player.has("Player_UUID") ? player.get("Player_UUID").getAsString() : (player.has("UUID") ? player.get("UUID").getAsString() : null);
                        String DefaultHome = player.has("DefaultHome") ? player.get("DefaultHome").getAsString() : "";
                        JsonObject deathLocation = new JsonObject();
                        deathLocation.addProperty("x", (Number)0);
                        deathLocation.addProperty("y", (Number)0);
                        deathLocation.addProperty("z", (Number)0);
                        deathLocation.addProperty("world", "");
                        JsonArray homes = new JsonArray();
                        if (player.has("Homes") && player.get("Homes").isJsonArray()) {
                            JsonArray tempHomes = player.get("Homes").getAsJsonArray();
                            boolean defaultHomeFound = false;
                            for (JsonElement homeElement : tempHomes) {
                                String homeWorld;
                                if (!homeElement.isJsonObject()) continue;
                                JsonObject home2 = homeElement.getAsJsonObject();
                                String homeName = home2.has("name") ? home2.get("name").getAsString() : "";
                                Integer homeX = home2.has("x") && home2.get("x").isJsonPrimitive() && home2.get("x").getAsJsonPrimitive().isNumber() ? Integer.valueOf((int)Math.floor(home2.get("x").getAsDouble())) : null;
                                Integer homeY = home2.has("y") && home2.get("y").isJsonPrimitive() && home2.get("y").getAsJsonPrimitive().isNumber() ? Integer.valueOf((int)Math.floor(home2.get("y").getAsDouble())) : null;
                                Integer homeZ = home2.has("z") && home2.get("z").isJsonPrimitive() && home2.get("z").getAsJsonPrimitive().isNumber() ? Integer.valueOf((int)Math.floor(home2.get("z").getAsDouble())) : null;
                                String string = homeWorld = home2.has("world") ? home2.get("world").getAsString() : "";
                                if (homeName.isBlank() || homeWorld.isBlank() || homeX == null || homeY == null || homeZ == null) continue;
                                if (!DefaultHome.isBlank() && homeName.equals(DefaultHome)) {
                                    defaultHomeFound = true;
                                }
                                JsonObject newHome = new JsonObject();
                                newHome.addProperty("name", homeName);
                                newHome.addProperty("x", (Number)homeX);
                                newHome.addProperty("y", (Number)homeY);
                                newHome.addProperty("z", (Number)homeZ);
                                newHome.addProperty("world", homeWorld);
                                homes.add((JsonElement)newHome);
                                hasInformation = true;
                            }
                            if (!defaultHomeFound) {
                                DefaultHome = "";
                            }
                        }
                        if (UUID == null || UUID.isBlank() || !hasInformation) continue;
                        JsonObject newPlayer = new JsonObject();
                        newPlayer.addProperty("UUID", UUID);
                        newPlayer.addProperty("DefaultHome", DefaultHome);
                        newPlayer.add("deathLocation", (JsonElement)deathLocation);
                        newPlayer.add("Homes", (JsonElement)homes);
                        newPlayersArray.add((JsonElement)newPlayer);
                    }
                }
                mainJsonObject.remove("Warps");
                mainJsonObject.add("Warps", (JsonElement)newWarpsArray);
                mainJsonObject.remove("Players");
                mainJsonObject.add("Players", (JsonElement)newPlayersArray);
                Gson gson = new GsonBuilder().create();
                byte[] json = gson.toJson((JsonElement)mainJsonObject).getBytes();
                Files.write(StorageManager.STORAGE_FILE, json, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                long endFileSize = Files.size(StorageManager.STORAGE_FILE);
                LOGGER.info("Success! Cleaned: {}B", (Object)Math.round(startFileSize - endFileSize));
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while cleaning the database!", (Throwable)e);
        }
    }
}

