/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import dev.mrsnowy.teleport_commands.TeleportCommands;
import dev.mrsnowy.teleport_commands.storage.StorageManager;
import dev.mrsnowy.teleport_commands.suggestions.HomeSuggestionProvider;
import dev.mrsnowy.teleport_commands.utils.tools;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class home {
    public static void register(class_2170 commandManager) {
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.SetHome(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while setting a home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.setError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.GoHome(player, "");
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while going home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.goError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).requires(source -> source.method_44023() != null)).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.GoHome(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while going to a specific home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.goError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.DeleteHome(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while deleting a home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.deleteError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"renamehome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.RenameHome(player, name, newName);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while renaming a home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.renameError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }))));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"defaulthome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.SetDefaultHome(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while setting the default home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.defaultError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.PrintHomes(player);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while printing the homes! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.homes.error", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }));
    }

    private static void SetHome(class_3222 player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        class_2338 blockPos = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
        class_3218 world = player.method_51469();
        Pair<StorageManager.StorageClass, StorageManager.StorageClass.Player> storages = StorageManager.GetPlayerStorage(player.method_5845());
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)storages.getSecond();
        boolean homeNotFound = true;
        for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
            if (!Objects.equals(currentHome.name, homeName)) continue;
            homeNotFound = false;
            break;
        }
        if (homeNotFound) {
            StorageManager.StorageClass.NamedLocation homeLocation = new StorageManager.StorageClass.NamedLocation();
            homeLocation.name = homeName;
            homeLocation.x = blockPos.method_10263();
            homeLocation.y = blockPos.method_10264();
            homeLocation.z = blockPos.method_10260();
            homeLocation.world = world.method_27983().method_29177().toString();
            playerStorage.Homes.add(homeLocation);
            if (playerStorage.Homes.size() == 1) {
                playerStorage.DefaultHome = homeName;
            }
            StorageManager.StorageSaver(storage);
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.set", player, new class_5250[0]), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.exists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void GoHome(class_3222 player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)StorageManager.GetPlayerStorage(player.method_5845()).getSecond();
        if (homeName.isEmpty()) {
            if (playerStorage.DefaultHome.isEmpty()) {
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
                return;
            }
            homeName = playerStorage.DefaultHome;
        }
        boolean foundWorld = false;
        block0: for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
            if (!Objects.equals(currentHome.name, homeName)) continue;
            for (class_3218 currentWorld : TeleportCommands.SERVER.method_3738()) {
                if (!Objects.equals(currentWorld.method_27983().method_29177().toString(), currentHome.world)) continue;
                foundWorld = true;
                class_2338 blockPos = new class_2338(currentHome.x, currentHome.y, currentHome.z);
                class_2338 playerBlockPos = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
                if (!playerBlockPos.equals((Object)blockPos) || player.method_37908() != currentWorld) {
                    player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.go", player, new class_5250[0]), true);
                    tools.Teleporter(player, currentWorld, new class_243((double)currentHome.x + 0.5, (double)currentHome.y, (double)currentHome.z + 0.5));
                    continue block0;
                }
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.goSame", player, new class_5250[0]).method_27692(class_124.field_1075), true);
                continue block0;
            }
        }
        if (!foundWorld) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void DeleteHome(class_3222 player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        Pair<StorageManager.StorageClass, StorageManager.StorageClass.Player> storages = StorageManager.GetPlayerStorage(player.method_5845());
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)storages.getSecond();
        boolean deletedHome = false;
        for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
            if (!Objects.equals(currentHome.name, homeName)) continue;
            playerStorage.Homes.remove(currentHome);
            StorageManager.StorageSaver(storage);
            deletedHome = true;
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.delete", player, new class_5250[0]), true);
            break;
        }
        if (!deletedHome) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void RenameHome(class_3222 player, String homeName, String newHomeName) throws Exception {
        homeName = homeName.toLowerCase();
        newHomeName = newHomeName.toLowerCase();
        Pair<StorageManager.StorageClass, StorageManager.StorageClass.Player> storages = StorageManager.GetPlayerStorage(player.method_5845());
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)storages.getSecond();
        boolean newNameNotFound = true;
        boolean WarpRenamed = false;
        for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
            if (!Objects.equals(currentHome.name, newHomeName)) continue;
            newNameNotFound = false;
            break;
        }
        if (newNameNotFound) {
            for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
                if (!Objects.equals(currentHome.name, homeName)) continue;
                if (Objects.equals(playerStorage.DefaultHome, currentHome.name)) {
                    playerStorage.DefaultHome = newHomeName;
                }
                currentHome.name = newHomeName;
                StorageManager.StorageSaver(storage);
                WarpRenamed = true;
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.rename", player, new class_5250[0]), true);
                break;
            }
            if (!WarpRenamed) {
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            }
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.renameExists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void SetDefaultHome(class_3222 player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        Pair<StorageManager.StorageClass, StorageManager.StorageClass.Player> storages = StorageManager.GetPlayerStorage(player.method_5845());
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)storages.getSecond();
        boolean homeExists = false;
        for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
            if (!Objects.equals(currentHome.name, homeName)) continue;
            homeExists = true;
            break;
        }
        if (homeExists) {
            if (!Objects.equals(playerStorage.DefaultHome, homeName)) {
                playerStorage.DefaultHome = homeName;
                StorageManager.StorageSaver(storage);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.default", player, new class_5250[0]), true);
            } else {
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.defaultSame", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            }
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void PrintHomes(class_3222 player) throws Exception {
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)StorageManager.GetPlayerStorage(player.method_5845()).getSecond();
        if (playerStorage.Homes.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.homes.homes", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_27693("\n"), false);
            for (StorageManager.StorageClass.NamedLocation currentHome : playerStorage.Homes) {
                String name = String.format("  - %s", currentHome.name);
                String coords = String.format("[X%d Y%d Z%d]", currentHome.x, currentHome.y, currentHome.z);
                String dimension = String.format(" [%s]", currentHome.world);
                if (Objects.equals(currentHome.name, playerStorage.DefaultHome)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.default", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075), false);
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)coords).method_27692(class_124.field_1076).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, String.format("X%d Y%d Z%d", currentHome.x, currentHome.y, currentHome.z))))).method_10852((class_2561)class_2561.method_43470((String)dimension).method_27692(class_124.field_1064).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, currentHome.world)))), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075).method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new class_5250[0]).method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/home %s", currentHome.name))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.rename", player, new class_5250[0]).method_27692(class_124.field_1078).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/renamehome %s ", currentHome.name))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.delete", player, new class_5250[0]).method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/delhome %s", currentHome.name))))).method_27693("\n"), false);
            }
        }
    }
}

