/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import dev.mrsnowy.teleport_commands.TeleportCommands;
import dev.mrsnowy.teleport_commands.storage.StorageManager;
import dev.mrsnowy.teleport_commands.suggestions.WarpSuggestionProvider;
import dev.mrsnowy.teleport_commands.utils.tools;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class warp {
    public static void register(class_2170 commandManager) {
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").requires(source -> source.method_44023() != null && source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.SetWarp(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while setting the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.setError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.GoToWarp(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while going to the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.goError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").requires(source -> source.method_44023() != null && source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.DeleteWarp(player, name);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while deleting to the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.deleteError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"renamewarp").requires(source -> source.method_44023() != null && source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.RenameWarp(player, name, newName);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while renaming the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.renameError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }))));
        commandManager.method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warps").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.PrintWarps(player);
            }
            catch (Exception e) {
                TeleportCommands.LOGGER.error("Error while printing warps!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warps.error", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }));
    }

    private static void SetWarp(class_3222 player, String warpName) throws Exception {
        warpName = warpName.toLowerCase();
        class_2338 blockPos = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
        class_3218 world = player.method_51469();
        Pair<StorageManager.StorageClass, List<StorageManager.StorageClass.NamedLocation>> storages = StorageManager.getWarpStorage();
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        List WarpStorage = (List)storages.getSecond();
        boolean warpNotFound = true;
        for (StorageManager.StorageClass.NamedLocation currentWarp : WarpStorage) {
            if (!Objects.equals(currentWarp.name, warpName)) continue;
            warpNotFound = false;
            break;
        }
        if (warpNotFound) {
            StorageManager.StorageClass.NamedLocation warpData = new StorageManager.StorageClass.NamedLocation();
            warpData.name = warpName;
            warpData.x = blockPos.method_10263();
            warpData.y = blockPos.method_10264();
            warpData.z = blockPos.method_10260();
            warpData.world = world.method_27983().method_29177().toString();
            storage.Warps.add(warpData);
            StorageManager.StorageSaver(storage);
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.set", player, new class_5250[0]), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.exists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void GoToWarp(class_3222 player, String warpName) throws Exception {
        warpName = warpName.toLowerCase();
        List WarpStorage = (List)StorageManager.getWarpStorage().getSecond();
        boolean foundWorld = false;
        block0: for (StorageManager.StorageClass.NamedLocation currentWarp : WarpStorage) {
            if (!Objects.equals(currentWarp.name, warpName)) continue;
            for (class_3218 currentWorld : TeleportCommands.SERVER.method_3738()) {
                if (!Objects.equals(currentWorld.method_27983().method_29177().toString(), currentWarp.world)) continue;
                foundWorld = true;
                class_2338 coords = new class_2338(currentWarp.x, currentWarp.y, currentWarp.z);
                class_2338 playerBlockPos = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
                if (!playerBlockPos.equals((Object)coords)) {
                    player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.go", player, new class_5250[0]), true);
                    tools.Teleporter(player, currentWorld, new class_243((double)currentWarp.x + 0.5, (double)currentWarp.y, (double)currentWarp.z + 0.5));
                    continue block0;
                }
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.goSame", player, new class_5250[0]).method_27692(class_124.field_1075), true);
                continue block0;
            }
        }
        if (!foundWorld) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void DeleteWarp(class_3222 player, String warpName) throws Exception {
        warpName = warpName.toLowerCase();
        Pair<StorageManager.StorageClass, List<StorageManager.StorageClass.NamedLocation>> storages = StorageManager.getWarpStorage();
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        List WarpStorage = (List)storages.getSecond();
        boolean deletedWarp = false;
        for (StorageManager.StorageClass.NamedLocation currentWarp : WarpStorage) {
            if (!Objects.equals(currentWarp.name, warpName)) continue;
            WarpStorage.remove(currentWarp);
            StorageManager.StorageSaver(storage);
            deletedWarp = true;
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.delete", player, new class_5250[0]), true);
            break;
        }
        if (!deletedWarp) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void RenameWarp(class_3222 player, String warpName, String newWarpName) throws Exception {
        warpName = warpName.toLowerCase();
        newWarpName = newWarpName.toLowerCase();
        Pair<StorageManager.StorageClass, List<StorageManager.StorageClass.NamedLocation>> storages = StorageManager.getWarpStorage();
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        List WarpStorage = (List)storages.getSecond();
        Object homeToRename = null;
        boolean newWarpNotFound = true;
        boolean WarpRenamed = false;
        for (StorageManager.StorageClass.NamedLocation currentWarp : WarpStorage) {
            if (!Objects.equals(currentWarp.name, newWarpName)) continue;
            newWarpNotFound = false;
            break;
        }
        if (newWarpNotFound) {
            for (StorageManager.StorageClass.NamedLocation currentWarp : WarpStorage) {
                if (!Objects.equals(currentWarp.name, warpName)) continue;
                currentWarp.name = newWarpName;
                StorageManager.StorageSaver(storage);
                WarpRenamed = true;
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.rename", player, new class_5250[0]), true);
                break;
            }
            if (!WarpRenamed) {
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            }
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.renameExists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void PrintWarps(class_3222 player) throws Exception {
        List WarpStorage = (List)StorageManager.getWarpStorage().getSecond();
        if (WarpStorage.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warps.warps", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_27693("\n"), false);
            for (StorageManager.StorageClass.NamedLocation currentWarp : WarpStorage) {
                String name = String.format("  - %s", currentWarp.name);
                String coords = String.format("[X%d Y%d Z%d]", currentWarp.x, currentWarp.y, currentWarp.z);
                String dimension = String.format(" [%s]", currentWarp.world);
                player.method_7353((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)coords).method_27692(class_124.field_1076).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, String.format("X%d Y%d Z%d", currentWarp.x, currentWarp.y, currentWarp.z))))).method_10852((class_2561)class_2561.method_43470((String)dimension).method_27692(class_124.field_1064).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, currentWarp.world)))), false);
                if (player.method_64475(4)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075).method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new class_5250[0]).method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/warp %s", currentWarp.name))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.rename", player, new class_5250[0]).method_27692(class_124.field_1078).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/renamewarp %s ", currentWarp.name))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.delete", player, new class_5250[0]).method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/delwarp %s", currentWarp.name))))).method_27693("\n"), false);
                    continue;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075).method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new class_5250[0]).method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/warp %s", currentWarp.name))))).method_27693("\n"), false);
            }
        }
    }
}

