/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsnowy.teleport_commands.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import dev.mrsnowy.teleport_commands.TeleportCommands;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StorageManager {
    public static Path STORAGE_FOLDER;
    public static Path STORAGE_FILE;

    public static void StorageInit() {
        STORAGE_FOLDER = TeleportCommands.SAVE_DIR.resolve("TeleportCommands/");
        STORAGE_FILE = STORAGE_FOLDER.resolve("storage.json");
        try {
            if (!Files.exists(STORAGE_FOLDER, new LinkOption[0])) {
                Files.createDirectories(STORAGE_FOLDER, new FileAttribute[0]);
            }
            if (!Files.exists(STORAGE_FILE, new LinkOption[0])) {
                Files.createFile(STORAGE_FILE, new FileAttribute[0]);
            }
            if (new File(String.valueOf(STORAGE_FILE)).length() == 0L) {
                StorageClass root = new StorageClass();
                root.Players = new ArrayList<StorageClass.Player>();
                root.Warps = new ArrayList<StorageClass.NamedLocation>();
                StorageManager.StorageSaver(root);
            }
        }
        catch (Exception e) {
            TeleportCommands.LOGGER.error("Error while creating the storage file! Exiting! {}", (Object)e.getMessage());
            System.exit(1);
        }
    }

    public static void StorageAdd(String UUID) throws Exception {
        StorageClass storage = StorageManager.StorageRetriever();
        Optional<StorageClass.Player> playerStorage = storage.Players.stream().filter(player -> Objects.equals(UUID, player.UUID)).findFirst();
        if (playerStorage.isEmpty()) {
            StorageClass.Player newPlayer = new StorageClass.Player();
            newPlayer.UUID = UUID;
            newPlayer.DefaultHome = "";
            newPlayer.deathLocation = new StorageClass.Location();
            newPlayer.deathLocation.x = new StorageClass.Location().x;
            newPlayer.deathLocation.y = new StorageClass.Location().y;
            newPlayer.deathLocation.z = new StorageClass.Location().z;
            newPlayer.deathLocation.world = "";
            newPlayer.Homes = new ArrayList<StorageClass.NamedLocation>();
            List<StorageClass.Player> playerList = storage.Players;
            playerList.add(newPlayer);
            StorageManager.StorageSaver(storage);
            TeleportCommands.LOGGER.info("Player '{}' added successfully in storage!", (Object)UUID);
        } else {
            TeleportCommands.LOGGER.info("Player '{}' already exists!", (Object)UUID);
        }
    }

    public static void StorageSaver(StorageClass storage) throws Exception {
        Gson gson = new GsonBuilder().create();
        byte[] json = gson.toJson((Object)storage).getBytes();
        Files.write(STORAGE_FILE, json, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static StorageClass StorageRetriever() throws Exception {
        if (new File(String.valueOf(STORAGE_FILE)).length() == 0L) {
            StorageManager.StorageInit();
        }
        String jsonContent = Files.readString(STORAGE_FILE);
        Gson gson = new GsonBuilder().create();
        return (StorageClass)gson.fromJson(jsonContent, StorageClass.class);
    }

    public static Pair<StorageClass, List<StorageClass.NamedLocation>> getWarpStorage() throws Exception {
        StorageClass storage = StorageManager.StorageRetriever();
        return new Pair((Object)storage, storage.Warps);
    }

    public static Pair<StorageClass, StorageClass.Player> GetPlayerStorage(String UUID) throws Exception {
        StorageClass storage = StorageManager.StorageRetriever();
        Optional<StorageClass.Player> playerStorage = storage.Players.stream().filter(player -> Objects.equals(UUID, player.UUID)).findFirst();
        if (playerStorage.isEmpty()) {
            StorageManager.StorageAdd(UUID);
            storage = StorageManager.StorageRetriever();
            playerStorage = storage.Players.stream().filter(player -> Objects.equals(UUID, player.UUID)).findFirst();
            if (playerStorage.isEmpty()) {
                throw new Exception("No Player found?!");
            }
        }
        return new Pair((Object)storage, (Object)playerStorage.get());
    }

    public static class StorageClass {
        public List<NamedLocation> Warps;
        public List<Player> Players;

        public static class Player {
            public String UUID;
            public String DefaultHome;
            public Location deathLocation;
            public List<NamedLocation> Homes;
        }

        public static class Location {
            public int x;
            public int y;
            public int z;
            public String world;
        }

        public static class NamedLocation {
            public String name;
            public int x;
            public int y;
            public int z;
            public String world;
        }
    }
}

