/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsnowy.teleport_commands.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import dev.mrsnowy.teleport_commands.TeleportCommands;
import dev.mrsnowy.teleport_commands.storage.StorageManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class tools {
    private static final Set<String> unsafeCollisionFreeBlocks = Set.of("block.minecraft.lava", "block.minecraft.flowing_lava", "block.minecraft.end_portal", "block.minecraft.end_gateway", "block.minecraft.fire", "block.minecraft.soul_fire", "block.minecraft.powder_snow", "block.minecraft.nether_portal");

    public static void Teleporter(final class_3222 player, final class_3218 world, class_243 coords) {
        world.method_65096((class_2394)class_2398.field_28013, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 20, 0.0, 0.0, 0.0, 0.01);
        world.method_65096((class_2394)class_2398.field_46911, player.method_23317(), player.method_23318(), player.method_23321(), 15, 0.0, 1.0, 0.0, 0.03);
        world.method_8396(null, player.method_24515(), class_3414.method_47908((class_2960)class_3417.field_14879.comp_3319()), class_3419.field_15248, 0.4f, 1.0f);
        boolean flying = player.method_31549().field_7479;
        player.method_48105(world, coords.field_1352, coords.field_1351, coords.field_1350, Set.of(), player.method_36454(), player.method_36455(), false);
        if (flying) {
            player.method_31549().field_7479 = true;
            player.method_7355();
        }
        world.method_8396(null, player.method_24515(), class_3414.method_47908((class_2960)class_3417.field_14879.comp_3319()), class_3419.field_15248, 0.4f, 1.0f);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                world.method_65096((class_2394)class_2398.field_28013, player.method_23317(), player.method_23318(), player.method_23321(), 20, 0.0, 1.0, 0.0, 0.01);
                world.method_65096((class_2394)class_2398.field_46911, player.method_23317(), player.method_23318(), player.method_23321(), 15, 0.0, 0.0, 0.0, 0.03);
            }
        }, 100L);
    }

    public static void DeathLocationUpdater(class_2338 pos, class_3218 world, String UUID2) throws Exception {
        Pair<StorageManager.StorageClass, StorageManager.StorageClass.Player> storages = StorageManager.GetPlayerStorage(UUID2);
        StorageManager.StorageClass storage = (StorageManager.StorageClass)storages.getFirst();
        StorageManager.StorageClass.Player playerStorage = (StorageManager.StorageClass.Player)storages.getSecond();
        playerStorage.deathLocation.x = pos.method_10263();
        playerStorage.deathLocation.y = pos.method_10264();
        playerStorage.deathLocation.z = pos.method_10260();
        playerStorage.deathLocation.world = world.method_27983().method_29177().toString();
        StorageManager.StorageSaver(storage);
    }

    public static Pair<Integer, Optional<class_243>> teleportSafetyChecker(int playerX, int playerY, int playerZ, class_3218 world, class_3222 player) {
        int rows = 3;
        class_2338 playerBlockPos = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
        class_2338 blockPos = new class_2338(playerX, playerY, playerZ);
        if (tools.isBlockPosUnsafe(blockPos, world)) {
            for (int row = 1; row <= rows; ++row) {
                for (int z = -row; z <= row; ++z) {
                    for (int x = -row; x <= row; ++x) {
                        for (int y = -row; y <= row; ++y) {
                            class_2338 newSafePos;
                            if (x != -row && x != row && z != -row && z != row && y != -row && y != row || tools.isBlockPosUnsafe(newSafePos = new class_2338(playerX + x, playerY + y, playerZ + z), world)) continue;
                            if (!playerBlockPos.equals((Object)newSafePos) || player.method_37908() != world) {
                                return new Pair((Object)0, Optional.of(new class_243((double)newSafePos.method_10263() + 0.5, (double)newSafePos.method_10264(), (double)newSafePos.method_10260() + 0.5)));
                            }
                            return new Pair((Object)1, Optional.of(new class_243((double)newSafePos.method_10263() + 0.5, (double)newSafePos.method_10264(), (double)newSafePos.method_10260() + 0.5)));
                        }
                    }
                }
            }
            return new Pair((Object)2, Optional.empty());
        }
        if (!playerBlockPos.equals((Object)blockPos) || player.method_37908() != world) {
            return new Pair((Object)0, Optional.of(new class_243((double)playerX + 0.5, (double)playerY, (double)playerZ + 0.5)));
        }
        return new Pair((Object)1, Optional.of(new class_243((double)playerX + 0.5, (double)playerY, (double)playerZ + 0.5)));
    }

    public static class_5250 getTranslatedText(String key, class_3222 player, class_5250 ... args) {
        String language = player.method_53823().comp_1951();
        String regex = "%(\\d+)%";
        Pattern pattern = Pattern.compile(regex);
        try {
            String filePath = String.format("/assets/%s/lang/%s.json", "teleport_commands", language);
            InputStream stream = TeleportCommands.class.getResourceAsStream(filePath);
            InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream), StandardCharsets.UTF_8);
            JsonElement json = JsonParser.parseReader((Reader)reader);
            String translation = json.getAsJsonObject().get(key).getAsString();
            Matcher matcher = pattern.matcher(Objects.requireNonNull(translation));
            class_5250 component = class_2561.method_43470((String)"");
            int lastIndex = 0;
            while (matcher.find()) {
                component.method_10852((class_2561)class_2561.method_43470((String)translation.substring(lastIndex, matcher.start())));
                int index = Integer.parseInt(matcher.group(1));
                component.method_10852((class_2561)args[index]);
                lastIndex = matcher.end();
            }
            component.method_27693(translation.substring(lastIndex));
            return component;
        }
        catch (Exception e) {
            TeleportCommands.LOGGER.error(e.toString());
            try {
                if (!Objects.equals(language, "en_us")) {
                    String filePath = String.format("/assets/%s/lang/en_us.json", "teleport_commands");
                    InputStream stream = TeleportCommands.class.getResourceAsStream(filePath);
                    InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream, "translation file stream cannot be null"), StandardCharsets.UTF_8);
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    String translation = json.getAsJsonObject().get(key).getAsString();
                    Matcher matcher = pattern.matcher(Objects.requireNonNull(translation, "translation cannot be null"));
                    class_5250 component = class_2561.method_43470((String)"");
                    int lastIndex = 0;
                    while (matcher.find()) {
                        component.method_10852((class_2561)class_2561.method_43470((String)translation.substring(lastIndex, matcher.start())));
                        int index = Integer.parseInt(matcher.group(1));
                        component.method_10852((class_2561)args[index]);
                        lastIndex = matcher.end();
                    }
                    component.method_27693(translation.substring(lastIndex));
                    return component;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            TeleportCommands.LOGGER.error("Key \"{}\" not found in the default language (en_us), sending raw key as fallback.", (Object)key);
            return class_2561.method_43470((String)key);
        }
    }

    private static boolean isBlockPosUnsafe(class_2338 bottomPlayer, class_3218 world) {
        class_2338 belowPlayer = new class_2338(bottomPlayer.method_10263(), bottomPlayer.method_10264() - 1, bottomPlayer.method_10260());
        String belowPlayerId = world.method_8320(belowPlayer).method_26204().method_63499();
        String BottomPlayerId = world.method_8320(bottomPlayer).method_26204().method_63499();
        class_2338 TopPlayer = new class_2338(bottomPlayer.method_10263(), bottomPlayer.method_10264() + 1, bottomPlayer.method_10260());
        String TopPlayerId = world.method_8320(TopPlayer).method_26204().method_63499();
        return !belowPlayerId.equals("block.minecraft.water") && world.method_8320(belowPlayer).method_26220((class_1922)world, belowPlayer).method_1110() || !world.method_8320(bottomPlayer).method_26220((class_1922)world, bottomPlayer).method_1110() || unsafeCollisionFreeBlocks.contains(BottomPlayerId) || unsafeCollisionFreeBlocks.contains(TopPlayerId);
    }
}

