/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.client.renderer.base;

import java.util.Map;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import nordmods.uselessreptile.client.model.URDragonModel;
import nordmods.uselessreptile.client.renderer.base.DragonEquipmentRenderer;
import nordmods.uselessreptile.client.renderer.layers.URGlowingLayer;
import nordmods.uselessreptile.client.renderer.special.SaddleEquipmentRenderer;
import nordmods.uselessreptile.client.util.DragonAssetCache;
import nordmods.uselessreptile.client.util.DragonEquipmentAnimatable;
import nordmods.uselessreptile.client.util.ResourceUtil;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.init.URTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public abstract class URDragonRenderer<T extends URDragonEntity>
extends GeoEntityRenderer<T> {
    private final DragonEquipmentRenderer dragonEquipmentRenderer = new DragonEquipmentRenderer();
    private final SaddleEquipmentRenderer saddleEquipmentRenderer = new SaddleEquipmentRenderer();

    public URDragonRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new URDragonModel());
        this.addRenderLayer(new URGlowingLayer(this));
    }

    protected float method_55831(class_10017 state) {
        return super.method_55831(state) * ((class_10042)state).field_53453;
    }

    public void postRender(class_4587 poseStack, T dragon, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, dragon, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (!ResourceUtil.isResourceReloadFinished) {
            return;
        }
        DragonAssetCache dragonAssetCache = ((URDragonEntity)dragon).getAssetCache();
        int i = 0;
        for (class_1799 itemStack : dragon.method_5661()) {
            DragonEquipmentRenderer usedRenderer;
            class_2960 id;
            int j = i++;
            if (itemStack.method_7960()) {
                dragonAssetCache.setEquipmentAnimatable(j, null);
                continue;
            }
            DragonEquipmentAnimatable dragonEquipmentAnimatable = dragonAssetCache.getEquipmentAnimatable(j);
            if (dragonEquipmentAnimatable == null || dragonEquipmentAnimatable.item != itemStack.method_7909()) {
                dragonEquipmentAnimatable = new DragonEquipmentAnimatable((URDragonEntity)dragon, itemStack.method_7909());
                dragonAssetCache.setEquipmentAnimatable(j, dragonEquipmentAnimatable);
            }
            if ((id = (usedRenderer = itemStack.method_31573(URTags.DRAGON_SADDLES) ? this.saddleEquipmentRenderer : this.dragonEquipmentRenderer).getGeoModel().getModelResource((GeoAnimatable)dragonEquipmentAnimatable, (GeoRenderer)usedRenderer)) == null) continue;
            BakedGeoModel bakedEquipmentModel = usedRenderer.getGeoModel().getBakedModel(id);
            id = usedRenderer.getGeoModel().getTextureResource((GeoAnimatable)dragonEquipmentAnimatable, (GeoRenderer)usedRenderer);
            if (id == null) continue;
            Map<String, GeoBone> equipmentBones = dragonEquipmentAnimatable.equipmentBones;
            if (equipmentBones.isEmpty()) {
                this.getEquipmentBones(equipmentBones, bakedEquipmentModel);
            }
            this.getGeoModel().getAnimationProcessor().getRegisteredBones().forEach(bone -> {
                GeoBone equipmentBone = (GeoBone)equipmentBones.get(bone.getName());
                if (equipmentBone != null) {
                    equipmentBone.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                    equipmentBone.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    equipmentBone.updatePosition(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                }
            });
            class_1921 renderType = usedRenderer.getGeoModel().getRenderType((GeoAnimatable)dragonEquipmentAnimatable, id);
            usedRenderer.render(poseStack, dragonEquipmentAnimatable, bufferSource, renderType, bufferSource.getBuffer(renderType), packedLight, partialTick);
        }
    }

    private void addChildren(Map<String, GeoBone> equipmentBones, GeoBone bone) {
        equipmentBones.put(bone.getName(), bone);
        for (GeoBone child : bone.getChildBones()) {
            this.addChildren(equipmentBones, child);
        }
    }

    private void getEquipmentBones(Map<String, GeoBone> equipmentBones, BakedGeoModel model) {
        for (GeoBone bone : model.topLevelBones()) {
            this.addChildren(equipmentBones, bone);
        }
    }
}

