/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.entity.base;

import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import nordmods.uselessreptile.common.entity.ai.control.FlyingDragonMoveControl;
import nordmods.uselessreptile.common.entity.ai.navigation.FlyingDragonNavigation;
import nordmods.uselessreptile.common.entity.base.FlyingDragon;
import nordmods.uselessreptile.common.entity.base.URRideableDragonEntity;
import nordmods.uselessreptile.common.init.URAttributes;
import nordmods.uselessreptile.common.network.LiftoffParticlesS2CPacket;

public abstract class URRideableFlyingDragonEntity
extends URRideableDragonEntity
implements FlyingDragon {
    protected final int maxInAirTimer = 600;
    protected float pitchLimitAir = 90.0f;
    private int flyUpWindow;
    private boolean jumpWasPressed;
    protected float tiltProgress;
    protected boolean shouldGlide;
    private int glideTimer = 100;
    private boolean forceFlight = false;
    public static final class_2940<Boolean> FLYING = class_2945.method_12791(URRideableFlyingDragonEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Byte> TILT_STATE = class_2945.method_12791(URRideableFlyingDragonEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Integer> IN_AIR_TIMER = class_2945.method_12791(URRideableFlyingDragonEntity.class, (class_2941)class_2943.field_13327);

    protected URRideableFlyingDragonEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new FlyingDragonMoveControl<URRideableFlyingDragonEntity>(this);
        this.field_6189 = new FlyingDragonNavigation<URRideableFlyingDragonEntity>(this, world);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FLYING, (Object)false);
        builder.method_56912(TILT_STATE, (Object)0);
        builder.method_56912(IN_AIR_TIMER, (Object)0);
    }

    @Override
    public int getInAirTimer() {
        return (Integer)this.field_6011.method_12789(IN_AIR_TIMER);
    }

    @Override
    public void setInAirTimer(int state) {
        this.field_6011.method_12778(IN_AIR_TIMER, (Object)state);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    @Override
    public void setFlying(boolean state) {
        this.field_6011.method_12778(FLYING, (Object)state);
    }

    @Override
    public byte getTiltState() {
        return (Byte)this.field_6011.method_12789(TILT_STATE);
    }

    @Override
    public void setTiltState(byte state) {
        this.field_6011.method_12778(TILT_STATE, (Object)state);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("IsFlying", this.isFlying());
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setFlying(tag.method_10577("IsFlying"));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.updateTiltProgress();
        if (this.method_37908().method_8608()) {
            --this.glideTimer;
            float accelerationModifier = (float)this.getAccelerationDuration() / this.getMaxAccelerationDuration();
            boolean bl = this.shouldGlide = accelerationModifier > 1.0f || this.glideTimer < 0 && (double)accelerationModifier > 0.9;
            if (this.glideTimer < -50 - this.method_59922().method_43048(100)) {
                this.glideTimer = 100 + this.method_59922().method_43048(100);
            }
        }
        this.checkForceFlight();
    }

    @Override
    public void method_6091(class_243 movementInput) {
        if (!this.method_5805()) {
            return;
        }
        if (!this.canBeControlledByRider() && this.isFlying()) {
            if (this.getInAirTimer() < 600) {
                this.setInAirTimer(this.getInAirTimer() + 1);
            } else {
                this.setInAirTimer(0);
            }
        }
        super.method_6091(movementInput);
    }

    @Override
    public void updateMovementModifiers() {
        if (!this.isMoving() || this.isFlying()) {
            this.method_5728(false);
        }
        if (this.method_5624()) {
            this.setSpeedMod(1.5f);
        } else if (this.isMovingBackwards() && this.isFlying()) {
            this.setSpeedMod(0.6f);
        } else {
            this.setSpeedMod(1.0f);
        }
        float speed = this.isFlying() ? (float)this.method_45325(class_5134.field_23720) : (float)this.method_45325(class_5134.field_23719);
        this.method_6125(speed * this.getSpeedModifier());
        if (this.method_24828()) {
            this.setFlying(false);
        }
        this.method_5875(this.isFlying());
    }

    @Override
    public class_243 updateMovementInput(class_1657 rider, class_243 movementInput) {
        float accelerationModifier;
        this.field_6250 = 0.0f;
        if (this.isMoveForwardPressed()) {
            this.field_6250 = 1.0f;
        }
        if (this.isMoveBackPressed()) {
            this.field_6250 = -1.0f;
        }
        boolean isInputGiven = this.isMoveBackPressed() || this.isMoveForwardPressed() || this.isDownPressed() || this.isJumpPressed();
        int accelerationDuration = this.getAccelerationDuration();
        if (accelerationDuration < 0) {
            accelerationDuration = 0;
        }
        if ((double)(accelerationModifier = (float)accelerationDuration / this.getMaxAccelerationDuration()) > 1.5) {
            accelerationModifier = 1.5f;
        }
        if (isInputGiven && this.getTurningState() == 0) {
            ++accelerationDuration;
        }
        if (this.isJumpPressed() && !this.isDownPressed() && (double)accelerationDuration > (double)this.getMaxAccelerationDuration() * 0.4) {
            accelerationDuration -= 2;
        }
        if (this.isDownPressed() && (float)accelerationDuration < this.getMaxAccelerationDuration() * 3.0f && this.isFlying()) {
            accelerationDuration += 2;
        }
        if (!this.isMoveBackPressed() && !this.isMoveForwardPressed() || this.isMoveBackPressed() && this.isMoveForwardPressed()) {
            accelerationDuration /= 2;
            if (!this.isMoving()) {
                accelerationDuration = 0;
            }
        }
        if (this.isMoveBackPressed() && !this.isMoveForwardPressed() && (double)accelerationDuration > (double)this.getMaxAccelerationDuration() * 0.25) {
            accelerationDuration -= 2;
        }
        if (!this.isDownPressed() && (float)accelerationDuration > this.getMaxAccelerationDuration()) {
            accelerationDuration -= 2;
            if (this.isJumpPressed()) {
                accelerationDuration -= 2;
            }
        }
        this.setAccelerationDuration(accelerationDuration);
        this.setMovingBackwards(this.isMoveBackPressed() || !this.isMoveForwardPressed() && !this.isMoveBackPressed() && this.isMoving());
        this.method_36457(class_3532.method_15363((float)rider.method_36455(), (float)(-this.getPitchLimit()), (float)this.getPitchLimit()));
        if (!this.isFlying()) {
            double landSpeed = (double)this.field_6250 * this.method_45325(class_5134.field_23719);
            if (this.isSprintPressed()) {
                this.method_5728(true);
            }
            if (this.isMovingBackwards() && (this.isMoveBackPressed() || this.isMoveBackPressed())) {
                this.method_5728(false);
            }
            this.setRotation(rider);
            if (this.isJumpPressed() && !this.jumpWasPressed) {
                if (this.flyUpWindow <= 0) {
                    this.jumpWasPressed = true;
                    this.flyUpWindow = 10;
                    if (this.method_24828()) {
                        this.method_6043();
                    }
                } else {
                    this.startToFly();
                    this.flyUpWindow = 0;
                }
            } else if (!this.isJumpPressed() && this.jumpWasPressed) {
                this.jumpWasPressed = false;
            }
            if (this.flyUpWindow > 0) {
                --this.flyUpWindow;
            } else {
                this.jumpWasPressed = false;
            }
            return new class_243(0.0, movementInput.field_1351 - 0.001, landSpeed);
        }
        double flyingSpeed = (double)this.field_6250 * this.method_45325(class_5134.field_23720);
        float pitchSpeed = 2.0f;
        this.setRotation(rider);
        float verticalSpeed = 0.0f;
        if (this.isJumpPressed()) {
            verticalSpeed = this.getVerticalSpeed();
            this.setTiltState((byte)1);
            if (!this.isMovingBackwards() && this.isMoving() && this.method_36455() > -this.getPitchLimit() && !this.isDownPressed()) {
                this.method_36457(this.method_36455() - pitchSpeed);
            }
        }
        if (this.isDownPressed()) {
            verticalSpeed = -this.getVerticalSpeed() * 1.3f;
            this.setTiltState((byte)2);
            if (!this.isMovingBackwards() && this.isMoving() && this.method_36455() < this.getPitchLimit()) {
                this.method_36457(this.method_36455() + pitchSpeed);
            }
        }
        float currentVerticalSpeed = (float)this.method_18798().method_10214();
        if (!this.isJumpPressed() && !this.isDownPressed()) {
            if (this.method_36455() != 0.0f) {
                if (this.method_36455() < 0.0f && this.method_36455() < -pitchSpeed) {
                    this.method_36457(this.method_36455() + pitchSpeed);
                }
                if (this.method_36455() > 0.0f && this.method_36455() > pitchSpeed) {
                    this.method_36457(this.method_36455() - pitchSpeed);
                }
                if (this.method_36455() < pitchSpeed && this.method_36455() > -pitchSpeed) {
                    this.method_36457(0.0f);
                }
            }
            if (currentVerticalSpeed != 0.0f) {
                verticalSpeed = currentVerticalSpeed * -0.5f;
            }
            this.setTiltState((byte)0);
        }
        return new class_243(0.0, (double)verticalSpeed * class_3532.method_15350((double)accelerationModifier, (double)0.25, (double)1.5), flyingSpeed * (double)accelerationModifier * 2.5);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return 0;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_5776() {
        return this.isFlying();
    }

    @Override
    public void startToFly() {
        this.method_6043();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.setAccelerationDuration(this.getAccelerationDuration() / 10);
            this.setFlying(true);
            for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)this.method_24515())) {
                LiftoffParticlesS2CPacket.send(player, this);
            }
        }
    }

    @Override
    public float getRotationSpeed() {
        if (this.isFlying()) {
            return this.getFlyingRotationSpeed() * this.getMovementSpeedModifier() / 2.0f;
        }
        return super.getRotationSpeed();
    }

    @Override
    public float getFlyingRotationSpeed() {
        return (float)this.method_45325(URAttributes.DRAGON_FLYING_ROTATION_SPEED);
    }

    @Override
    public float getPitchLimit() {
        if (this.isFlying() && this.isMoving() && !this.isMovingBackwards()) {
            return this.pitchLimitAir;
        }
        return this.pitchLimitGround;
    }

    @Override
    protected float getMovementSpeedModifier() {
        if (!this.isFlying()) {
            return super.getMovementSpeedModifier();
        }
        double baseSpeed = this.method_45326(class_5134.field_23720);
        double speed = this.method_45326(class_5134.field_23720);
        return (float)(speed / baseSpeed);
    }

    @Override
    public int getMaxInAirTimer() {
        return 600;
    }

    protected float method_49484() {
        float movementSpeed = this.method_6029();
        return this.method_42148() ? movementSpeed * 0.1f : movementSpeed * 0.14f;
    }

    private void updateTiltProgress() {
        switch (this.getTiltState()) {
            case 1: {
                if (!(this.tiltProgress < 10.0f)) break;
                this.tiltProgress += 1.0f;
                break;
            }
            case 2: {
                if (!(this.tiltProgress > -10.0f)) break;
                this.tiltProgress -= 1.0f;
                break;
            }
            default: {
                if (this.tiltProgress == 0.0f) break;
                if (this.tiltProgress > 0.0f) {
                    this.tiltProgress -= 1.0f;
                    break;
                }
                this.tiltProgress += 1.0f;
            }
        }
    }

    @Override
    public float getVerticalSpeed() {
        return (float)this.method_45325(URAttributes.DRAGON_VERTICAL_SPEED);
    }

    public FlyingDragonMoveControl<? extends FlyingDragon> getMoveControl() {
        return (FlyingDragonMoveControl)this.field_6207;
    }

    @Override
    public void forceFlightNextTick() {
        this.forceFlight = true;
    }

    private void checkForceFlight() {
        if (this.forceFlight) {
            this.forceFlight = false;
            this.startToFly();
        }
    }
}

