/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.util.dragon_spawn;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import org.jetbrains.annotations.NotNull;

public class DragonSpawn {
    private final String variant;
    private final SpawnConditions conditions;
    public static final Codec<DragonSpawn> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("variant").forGetter(DragonSpawn::variant), (App)SpawnConditions.CODEC.fieldOf("conditions").forGetter(DragonSpawn::conditions)).apply((Applicative)instance, DragonSpawn::new));
    private static final Map<String, List<DragonSpawn>> dragonSpawnsHolder = new HashMap<String, List<DragonSpawn>>();

    protected DragonSpawn(String variant, SpawnConditions conditions) {
        this.variant = variant;
        this.conditions = conditions;
    }

    public String variant() {
        return this.variant;
    }

    public SpawnConditions conditions() {
        return this.conditions;
    }

    public static List<DragonSpawn> getAllVariants(String name) {
        return dragonSpawnsHolder.get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void clearSpawns() {
        dragonSpawnsHolder.clear();
    }

    public static void addSpawn(class_1299<? extends URDragonEntity> type, DragonSpawn data) {
        DragonSpawn.addSpawn(class_1299.method_5890(type).method_12832(), data);
    }

    public static void addSpawn(String name, DragonSpawn data) {
        List<DragonSpawn> content = dragonSpawnsHolder.get(name);
        if (content == null) {
            content = new ArrayList<DragonSpawn>();
        }
        content.add(data);
        dragonSpawnsHolder.put(name, content);
    }

    public static void debugPrint() {
        for (Map.Entry<String, List<DragonSpawn>> entry : dragonSpawnsHolder.entrySet()) {
            for (DragonSpawn spawn : entry.getValue()) {
                UselessReptile.LOGGER.debug("{}: added spawn entry for variant \"{}\" with conditions: {}", new Object[]{entry.getKey(), spawn.variant(), spawn.conditions()});
            }
        }
    }

    public static Set<Map.Entry<String, List<DragonSpawn>>> getEntries() {
        return dragonSpawnsHolder.entrySet();
    }

    public static class SpawnConditions {
        private final int weight;
        @NotNull
        private final Optional<List<class_5699.class_7476>> allowedBiomes;
        @NotNull
        private final Optional<List<class_5699.class_7476>> bannedBiomes;
        @NotNull
        private final Optional<List<class_5699.class_7476>> allowedBlocks;
        @NotNull
        private final Optional<List<class_5699.class_7476>> bannedBlocks;
        @NotNull
        private final Optional<AltitudeRestriction> altitudeRestriction;
        public static final Codec<SpawnConditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("weight").forGetter(SpawnConditions::weight), (App)class_5699.field_39274.listOf().optionalFieldOf("allowed_biomes").forGetter(SpawnConditions::allowedBiomes), (App)class_5699.field_39274.listOf().optionalFieldOf("banned_biomes").forGetter(SpawnConditions::bannedBiomes), (App)class_5699.field_39274.listOf().optionalFieldOf("allowed_blocks").forGetter(SpawnConditions::allowedBlocks), (App)class_5699.field_39274.listOf().optionalFieldOf("banned_blocks").forGetter(SpawnConditions::bannedBlocks), (App)AltitudeRestriction.CODEC.optionalFieldOf("altitude").forGetter(SpawnConditions::altitudeRestriction)).apply((Applicative)instance, SpawnConditions::new));

        private SpawnConditions(int weight, @NotNull Optional<List<class_5699.class_7476>> allowedBiomes, @NotNull Optional<List<class_5699.class_7476>> bannedBiomes, @NotNull Optional<List<class_5699.class_7476>> allowedBlocks, @NotNull Optional<List<class_5699.class_7476>> bannedBlocks, @NotNull Optional<AltitudeRestriction> altitudeRestriction) {
            this.weight = weight;
            this.allowedBiomes = allowedBiomes;
            this.bannedBiomes = bannedBiomes;
            this.allowedBlocks = allowedBlocks;
            this.bannedBlocks = bannedBlocks;
            this.altitudeRestriction = altitudeRestriction;
        }

        public int weight() {
            return this.weight;
        }

        public Optional<List<class_5699.class_7476>> allowedBiomes() {
            return this.allowedBiomes;
        }

        public Optional<List<class_5699.class_7476>> bannedBiomes() {
            return this.bannedBiomes;
        }

        public Optional<List<class_5699.class_7476>> allowedBlocks() {
            return this.allowedBlocks;
        }

        public Optional<List<class_5699.class_7476>> bannedBlocks() {
            return this.bannedBlocks;
        }

        public Optional<AltitudeRestriction> altitudeRestriction() {
            return this.altitudeRestriction;
        }

        public String toString() {
            List<class_5699.class_7476> entryIdList;
            StringBuilder builder = new StringBuilder();
            builder.append("{Weight: ").append(this.weight());
            if (this.allowedBiomes().isPresent()) {
                builder.append(", Allowed Biomes: [");
                entryIdList = this.allowedBiomes().get();
                for (class_5699.class_7476 entryId : entryIdList) {
                    if (!entryIdList.getFirst().equals((Object)entryId)) {
                        builder.append(", ");
                    }
                    builder.append(entryId.toString());
                }
                builder.append("]");
            }
            if (this.bannedBiomes().isPresent()) {
                builder.append(", Banned Biomes: [");
                entryIdList = this.bannedBiomes().get();
                for (class_5699.class_7476 entryId : entryIdList) {
                    if (!entryIdList.getFirst().equals((Object)entryId)) {
                        builder.append(", ");
                    }
                    builder.append(entryId.toString());
                }
                builder.append("]");
            }
            if (this.allowedBlocks().isPresent()) {
                builder.append(", Allowed Blocks: [");
                entryIdList = this.allowedBlocks().get();
                for (class_5699.class_7476 entryId : entryIdList) {
                    if (!entryIdList.getFirst().equals((Object)entryId)) {
                        builder.append(", ");
                    }
                    builder.append(entryId.toString());
                }
                builder.append("]");
            }
            if (this.bannedBlocks().isPresent()) {
                builder.append(", Banned Blocks: [");
                entryIdList = this.bannedBlocks().get();
                for (class_5699.class_7476 entryId : entryIdList) {
                    if (!entryIdList.getFirst().equals((Object)entryId)) {
                        builder.append(", ");
                    }
                    builder.append(entryId.toString());
                }
                builder.append("]");
            }
            if (this.altitudeRestriction().isPresent()) {
                builder.append(", ").append(this.altitudeRestriction().get());
            }
            builder.append("}");
            return builder.toString();
        }

        public static class AltitudeRestriction {
            private final Optional<Integer> min;
            private final Optional<Integer> max;
            public static final Codec<AltitudeRestriction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min").forGetter(altitudeRestriction -> altitudeRestriction.min), (App)Codec.INT.optionalFieldOf("max").forGetter(altitudeRestriction -> altitudeRestriction.max)).apply((Applicative)instance, AltitudeRestriction::new));

            private AltitudeRestriction(Optional<Integer> min, Optional<Integer> max) {
                this.min = min;
                this.max = max;
            }

            public int min() {
                return this.min.orElse(Integer.MIN_VALUE);
            }

            public int max() {
                return this.max.orElse(Integer.MAX_VALUE);
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("Altitude: {");
                if (this.min.isPresent()) {
                    builder.append("Min: ").append(this.min());
                    if (this.max.isPresent()) {
                        builder.append(", ");
                    }
                }
                if (this.max.isPresent()) {
                    builder.append("Max: ").append(this.max());
                }
                builder.append("}");
                return builder.toString();
            }
        }
    }

    public static class Builder {
        private String variant;
        private Integer weight;
        private List<class_5699.class_7476> allowedBiomes;
        private List<class_5699.class_7476> bannedBiomes;
        private List<class_5699.class_7476> allowedBlocks;
        private List<class_5699.class_7476> bannedBlocks;
        private Integer minAltitude;
        private Integer maxAltitude;

        private Builder() {
        }

        public DragonSpawn build() {
            Optional<SpawnConditions.AltitudeRestriction> altitudeRestriction;
            Optional<List<class_5699.class_7476>> bannedBlocks;
            if (this.variant == null) {
                throw new IllegalStateException("Variant must be specified");
            }
            if (this.weight == null) {
                throw new IllegalStateException("Weight must be specified");
            }
            Optional<List<class_5699.class_7476>> allowedBiomes = this.allowedBiomes != null ? Optional.of(this.allowedBiomes) : Optional.empty();
            Optional<List<class_5699.class_7476>> bannedBiomes = this.bannedBiomes != null ? Optional.of(this.bannedBiomes) : Optional.empty();
            Optional<List<class_5699.class_7476>> allowedBlocks = this.allowedBlocks != null ? Optional.of(this.allowedBlocks) : Optional.empty();
            Optional<List<class_5699.class_7476>> optional = bannedBlocks = this.bannedBlocks != null ? Optional.of(this.bannedBlocks) : Optional.empty();
            if (this.minAltitude != null || this.maxAltitude != null) {
                Optional<Integer> minAltitude = this.minAltitude != null ? Optional.of(this.minAltitude) : Optional.empty();
                Optional<Integer> maxAltitude = this.maxAltitude != null ? Optional.of(this.maxAltitude) : Optional.empty();
                altitudeRestriction = Optional.of(new SpawnConditions.AltitudeRestriction(minAltitude, maxAltitude));
            } else {
                altitudeRestriction = Optional.empty();
            }
            return new DragonSpawn(this.variant, new SpawnConditions(this.weight, allowedBiomes, bannedBiomes, allowedBlocks, bannedBlocks, altitudeRestriction));
        }

        public Builder setVariant(String variant) {
            this.variant = variant;
            return this;
        }

        public Builder setWeight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Builder setMinAltitude(Integer minAltitude) {
            this.minAltitude = minAltitude;
            return this;
        }

        public Builder setMaxAltitude(Integer maxAltitude) {
            this.maxAltitude = maxAltitude;
            return this;
        }

        public Builder addAllowedBiome(class_5321<class_1959> biomeRegistryKey) {
            if (this.allowedBiomes == null) {
                this.allowedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBiomes.add(new class_5699.class_7476(biomeRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addAllowedBiomeTag(class_6862<class_1959> biomeTagKey) {
            if (this.allowedBiomes == null) {
                this.allowedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBiomes.add(new class_5699.class_7476(biomeTagKey.comp_327(), true));
            return this;
        }

        public Builder addBannedBiome(class_5321<class_1959> biomeRegistryKey) {
            if (this.bannedBiomes == null) {
                this.bannedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBiomes.add(new class_5699.class_7476(biomeRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addBannedBiomeTag(class_6862<class_1959> biomeTagKey) {
            if (this.bannedBiomes == null) {
                this.bannedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBiomes.add(new class_5699.class_7476(biomeTagKey.comp_327(), true));
            return this;
        }

        public Builder addAllowedBlock(class_5321<class_2248> blockRegistryKey) {
            if (this.allowedBlocks == null) {
                this.allowedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBlocks.add(new class_5699.class_7476(blockRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addAllowedBlockTag(class_6862<class_2248> blockTagKey) {
            if (this.allowedBlocks == null) {
                this.allowedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBlocks.add(new class_5699.class_7476(blockTagKey.comp_327(), true));
            return this;
        }

        public Builder addBannedBlock(class_5321<class_2248> blockRegistryKey) {
            if (this.bannedBlocks == null) {
                this.bannedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBlocks.add(new class_5699.class_7476(blockRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addBannedBlockTag(class_6862<class_2248> blockTagKey) {
            if (this.bannedBlocks == null) {
                this.bannedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBlocks.add(new class_5699.class_7476(blockTagKey.comp_327(), true));
            return this;
        }
    }
}

