/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.util.dragon_spawn;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.util.dragon_spawn.DragonSpawn;

public class DragonSpawnUtil {
    public static boolean isBiomeInList(List<class_5699.class_7476> list, class_1936 world, class_2338 blockPos) {
        class_6880 biome = world.method_23753(blockPos);
        for (class_5699.class_7476 tagEntryId : list) {
            if (!(tagEntryId.comp_814() ? biome.method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagEntryId.comp_813())) : biome.method_40226(tagEntryId.comp_813()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockInList(List<class_5699.class_7476> list, class_1936 world, class_2338 blockPos) {
        class_6880 block = world.method_8320(blockPos.method_10074()).method_41520();
        for (class_5699.class_7476 tagEntryId : list) {
            if (!(tagEntryId.comp_814() ? block.method_40220(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagEntryId.comp_813())) : block.method_40226(tagEntryId.comp_813()))) continue;
            return true;
        }
        return false;
    }

    public static void assignVariantFromList(URDragonEntity entity, List<DragonSpawn> variants, class_3730 spawnReason) {
        boolean canWarn;
        int totalWeight = 0;
        for (DragonSpawn variant : variants) {
            totalWeight += variant.conditions().weight();
        }
        boolean bl = canWarn = spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16467 || spawnReason == class_3730.field_16472 || spawnReason == class_3730.field_16466;
        if (totalWeight <= 0) {
            if (canWarn) {
                UselessReptile.LOGGER.warn("Failed to set variant for {} at {} as none can spawn there. Setting default", (Object)entity.method_5477().getString(), (Object)entity.method_24515());
            }
            entity.setVariant(entity.getDefaultVariant());
            return;
        }
        int roll = entity.method_59922().method_43048(totalWeight);
        int previousBound = 0;
        for (DragonSpawn variant : variants) {
            if (roll >= previousBound && roll < previousBound + variant.conditions().weight()) {
                entity.setVariant(variant.variant());
                break;
            }
            previousBound += variant.conditions().weight();
        }
    }

    public static List<DragonSpawn> getAvailableVariants(class_1936 world, URDragonEntity entity) {
        return DragonSpawnUtil.getAvailableVariants(world, entity.method_24515(), entity.getDragonID());
    }

    public static List<DragonSpawn> getAvailableVariants(class_1936 world, class_2338 pos, String name) {
        List<DragonSpawn> variants = DragonSpawn.getAllVariants(name);
        if (variants == null) {
            throw new RuntimeException("Failed to get variants for " + name);
        }
        ArrayList<DragonSpawn> allowedVariants = new ArrayList<DragonSpawn>(variants.size());
        variants.forEach(variant -> {
            List<class_5699.class_7476> list;
            DragonSpawn.SpawnConditions.AltitudeRestriction restriction;
            if (variant.conditions().altitudeRestriction().isPresent() && ((restriction = variant.conditions().altitudeRestriction().get()).min() > pos.method_10264() || restriction.max() <= pos.method_10264())) {
                return;
            }
            if (variant.conditions().bannedBiomes().isPresent() && !(list = variant.conditions().bannedBiomes().get()).isEmpty() && DragonSpawnUtil.isBiomeInList(list, world, pos)) {
                return;
            }
            if (variant.conditions().allowedBiomes().isPresent() && !(list = variant.conditions().allowedBiomes().get()).isEmpty() && !DragonSpawnUtil.isBiomeInList(list, world, pos)) {
                return;
            }
            if (variant.conditions().bannedBlocks().isPresent() && !(list = variant.conditions().bannedBlocks().get()).isEmpty() && DragonSpawnUtil.isBlockInList(list, world, pos)) {
                return;
            }
            if (variant.conditions().allowedBlocks().isPresent() && !(list = variant.conditions().allowedBlocks().get()).isEmpty() && !DragonSpawnUtil.isBlockInList(list, world, pos)) {
                return;
            }
            allowedVariants.add((DragonSpawn)variant);
        });
        return allowedVariants;
    }
}

