/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.datagen.data.dragon_spawn;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.common.init.UREntities;
import nordmods.uselessreptile.common.util.dragon_spawn.DragonSpawn;
import nordmods.uselessreptile.datagen.data.dragon_spawn.EventDragonSpawn;

public class URDragonSpawnProvider
implements class_2405 {
    protected final FabricDataOutput output;
    private final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registryLookupFuture;

    public URDragonSpawnProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.output = output;
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "dragon_spawns");
        this.registryLookupFuture = registriesFuture;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registryLookupFuture.thenCompose(registryLookupFuture -> {
            this.addSpawnEntries();
            ArrayList list = new ArrayList();
            DragonSpawn.getEntries().forEach(entry -> {
                String dragon = (String)entry.getKey();
                List spawns = (List)entry.getValue();
                spawns.forEach(dragonSpawn -> {
                    class_2960 id = dragonSpawn instanceof EventDragonSpawn ? this.getEventId(dragon, dragonSpawn.variant()) : this.getId(dragon, dragonSpawn.variant());
                    Path path = this.pathResolver.method_44107(id);
                    list.add(class_2405.method_53496((class_7403)writer, (class_7225.class_7874)registryLookupFuture, DragonSpawn.CODEC, (Object)dragonSpawn, (Path)path));
                });
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    protected class_2960 getId(String dragon, String variant) {
        return UselessReptile.id(dragon + "/" + variant);
    }

    protected class_2960 getEventId(String dragon, String variant) {
        return UselessReptile.id(dragon + "/event/" + variant);
    }

    public void addSpawnEntries() {
        this.addWyvernEntry("green");
        this.addWyvernEntry("brown");
        this.addMoleclawEntry("black", 13);
        this.addMoleclawEntry("brown", 13);
        this.addMoleclawEntry("grey", 13);
        this.addMoleclawEntry("albino", 1);
        this.addRiverPikehornEntry("blue");
        this.addRiverPikehornEntry("dark_blue");
        this.addRiverPikehornEntry("green");
        this.addRiverPikehornEntry("dark_green");
        this.addRiverPikehornEntry("purple");
        this.addRiverPikehornEntry("dark_purple");
        this.addRiverPikehornEntry("teal");
        this.addRiverPikehornEntry("dark_teal");
        DragonSpawn lightningChaserBlueEvent = DragonSpawn.builder().setVariant("blue").setWeight(9).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OCEAN).setMinAltitude(62).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_51989).build();
        DragonSpawn lightningChaserBrownEvent = DragonSpawn.builder().setVariant("brown").setWeight(9).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_DRY).setMinAltitude(62).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_51989).build();
        DragonSpawn lightningChaserGreyEvent = DragonSpawn.builder().setVariant("grey").setWeight(9).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OVERWORLD).addBannedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OCEAN).addBannedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_DRY).setMinAltitude(62).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_51989).build();
        DragonSpawn lightningChaserPurpleEvent = DragonSpawn.builder().setVariant("purple").setWeight(1).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OVERWORLD).setMinAltitude(62).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_51989).build();
        DragonSpawn.addSpawn(UREntities.LIGHTNING_CHASER_ENTITY, (DragonSpawn)this.getEventEntry(lightningChaserBlueEvent));
        DragonSpawn.addSpawn(UREntities.LIGHTNING_CHASER_ENTITY, (DragonSpawn)this.getEventEntry(lightningChaserBrownEvent));
        DragonSpawn.addSpawn(UREntities.LIGHTNING_CHASER_ENTITY, (DragonSpawn)this.getEventEntry(lightningChaserGreyEvent));
        DragonSpawn.addSpawn(UREntities.LIGHTNING_CHASER_ENTITY, (DragonSpawn)this.getEventEntry(lightningChaserPurpleEvent));
    }

    protected void addWyvernEntry(String variant) {
        DragonSpawn spawn = DragonSpawn.builder().setVariant(variant).setWeight(1).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_SWAMP).addBannedBiome((class_5321<class_1959>)class_1972.field_38748).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_35567).build();
        DragonSpawn.addSpawn(UREntities.WYVERN_ENTITY, spawn);
    }

    protected void addMoleclawEntry(String variant, int weight) {
        DragonSpawn spawn = DragonSpawn.builder().setVariant(variant).setWeight(weight).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OVERWORLD).addAllowedBlockTag((class_6862<class_2248>)ConventionalBlockTags.ORES).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_28992).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_28993).addAllowedBlock((class_5321<class_2248>)class_2246.field_10566.method_40142().method_40237()).addAllowedBlock((class_5321<class_2248>)class_2246.field_10255.method_40142().method_40237()).build();
        DragonSpawn.addSpawn(UREntities.MOLECLAW_ENTITY, spawn);
    }

    protected void addRiverPikehornEntry(String variant) {
        DragonSpawn spawn = DragonSpawn.builder().setVariant(variant).setWeight(1).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_BEACH).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_RIVER).addAllowedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OCEAN).addBannedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_AQUATIC_ICY).addBannedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_SNOWY).addBannedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_COLD).addBannedBiomeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_ICY).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_35567).addAllowedBlockTag((class_6862<class_2248>)class_3481.field_15466).addAllowedBlock((class_5321<class_2248>)class_2246.field_10255.method_40142().method_40237()).setMinAltitude(62).build();
        DragonSpawn.addSpawn(UREntities.RIVER_PIKEHORN_ENTITY, spawn);
    }

    protected EventDragonSpawn getEventEntry(DragonSpawn spawn) {
        return new EventDragonSpawn(spawn.variant(), spawn.conditions());
    }

    public String method_10321() {
        return "Dragon Spawns";
    }
}

